package com.stereodustparticles.mooler_caster_console;

import java.awt.Dialog.ModalityType;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JButton;
import java.awt.event.ItemListener;
import java.io.File;
import java.awt.event.ItemEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

// SDP Mooler Caster Console
// Ridiculously simple radio DJ program, with a 16-slot soundboard and 2-deck music player
// Written by Ben A. (IfYouLikeGoodIdeas)

// This class houses the Soundboard Preferences dialog

public class SpotPrefs {
	// ** KEYS AND DEFAULT VALUES FOR SOUNDBOARD PREFERENCES **
	public static final String KEEP_SDP_SPOTS = "Keep_SDP_Spots";
	public static final boolean DEFAULT_KEEP_SDP_SPOTS = true;
	
	public static final String SDP_SPOT_SAVE_LOC = "SDP_Spot_Save_Location";
	public static final String DEFAULT_SDP_SPOT_SAVE_LOC = System.getProperty("user.home") + File.separator + "Downloads" + File.separator + "SDP";
	
	public static final String STARTUP_LAYOUT = "Use_Startup_Layout";
	public static final boolean DEFAULT_STARTUP_LAYOUT = false;
	
	public static final String STARTUP_LAYOUT_LOC = "Startup_Layout_Location";
	public static final String DEFAULT_STARTUP_LAYOUT_LOC = "";
	
	// Misc. GUI stuff
	private static JDialog spotPrefs;
	private static JTextField storageFolder;
	private static JTextField startupLayout;
	private static JCheckBox keepSDPSpots;
	private static JCheckBox loadThisLayout;
	
	/**
	 * Initialize the dialog
	 * @wbp.parser.entryPoint
	 */
	public static void initialize() {
		spotPrefs = new JDialog();
		
		spotPrefs.setResizable(false);
		spotPrefs.setTitle("Soundboard Preferences");
		spotPrefs.setModalityType(ModalityType.APPLICATION_MODAL);
		spotPrefs.setModal(true);
		spotPrefs.setBounds(100, 100, 440, 390);
		spotPrefs.getContentPane().setLayout(null);
		
		// Keep spots stored locally
		JLabel lblStorageFolder = new JLabel("Storage Folder:");
		lblStorageFolder.setEnabled(false);
		lblStorageFolder.setBounds(17, 67, 99, 14);
		spotPrefs.getContentPane().add(lblStorageFolder);
		
		storageFolder = new JTextField();
		storageFolder.setEnabled(false);
		storageFolder.setBounds(17, 85, 308, 20);
		spotPrefs.getContentPane().add(storageFolder);
		storageFolder.setColumns(10);
		
		JButton browseFolder = new JButton("Browse...");
		browseFolder.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// Load a JFileChooser to use to select a folder
				JFileChooser chooser = new JFileChooser();
				
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setCurrentDirectory(new File(storageFolder.getText()));
				
				int res = chooser.showOpenDialog(spotPrefs);
				
				if ( res != JFileChooser.CANCEL_OPTION ) {
					storageFolder.setText(chooser.getSelectedFile().getAbsolutePath());
				}
			}
		});
		browseFolder.setEnabled(false);
		browseFolder.setBounds(328, 84, 89, 23);
		spotPrefs.getContentPane().add(browseFolder);
		
		keepSDPSpots = new JCheckBox("Keep spots from the SDP site stored locally (recommended)");
		keepSDPSpots.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if ( e.getStateChange() == ItemEvent.SELECTED ) {
					lblStorageFolder.setEnabled(true);
					storageFolder.setEnabled(true);
					browseFolder.setEnabled(true);
				}
				else {
					lblStorageFolder.setEnabled(false);
					storageFolder.setEnabled(false);
					browseFolder.setEnabled(false);
				}
			}
		});
		keepSDPSpots.setBounds(17, 25, 400, 23);
		spotPrefs.getContentPane().add(keepSDPSpots);
		
		// Load layout at startup
		startupLayout = new JTextField();
		startupLayout.setEnabled(false);
		startupLayout.setColumns(10);
		startupLayout.setBounds(17, 198, 308, 20);
		spotPrefs.getContentPane().add(startupLayout);
		
		JButton browseLayout = new JButton("Browse...");
		browseLayout.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// Load a JFileChooser to use to select a layout
				JFileChooser chooser = new JFileChooser();
				
				chooser.setFileFilter(SDPConsole.LAYOUT_FILE_FILTER);
				chooser.setCurrentDirectory(new File(startupLayout.getText()));
				
				int res = chooser.showOpenDialog(spotPrefs);
				
				if ( res != JFileChooser.CANCEL_OPTION ) {
					startupLayout.setText(chooser.getSelectedFile().getAbsolutePath());
				}
			}
		});
		browseLayout.setEnabled(false);
		browseLayout.setBounds(328, 197, 89, 23);
		spotPrefs.getContentPane().add(browseLayout);
		
		loadThisLayout = new JCheckBox("Load the following layout file at startup:");
		loadThisLayout.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if ( e.getStateChange() == ItemEvent.SELECTED ) {
					startupLayout.setEnabled(true);
					browseLayout.setEnabled(true);
				}
				else {
					startupLayout.setEnabled(false);
					browseLayout.setEnabled(false);
				}
			}
		});
		loadThisLayout.setBounds(17, 168, 400, 23);
		spotPrefs.getContentPane().add(loadThisLayout);
		
		// Save/Cancel buttons
		JButton btnSave = new JButton("Save");
		btnSave.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				save();
			}
		});
		btnSave.setBounds(70, 313, 89, 23);
		spotPrefs.getContentPane().add(btnSave);
		
		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent arg0) {
				spotPrefs.setVisible(false);
			}
		});
		btnCancel.setBounds(275, 313, 89, 23);
		spotPrefs.getContentPane().add(btnCancel);
	}
	
	// Show the soundboard preferences dialog
	public static void show() {
		// Fill out the fields with the stored preferences
		keepSDPSpots.setSelected(SDPConsole.prefs.getBoolean(KEEP_SDP_SPOTS, DEFAULT_KEEP_SDP_SPOTS));
		storageFolder.setText(SDPConsole.prefs.get(SDP_SPOT_SAVE_LOC, DEFAULT_SDP_SPOT_SAVE_LOC));
		loadThisLayout.setSelected(SDPConsole.prefs.getBoolean(STARTUP_LAYOUT, DEFAULT_STARTUP_LAYOUT));
		startupLayout.setText(SDPConsole.prefs.get(STARTUP_LAYOUT_LOC, DEFAULT_STARTUP_LAYOUT_LOC));
		
		// Now we can actually show the dialog
		spotPrefs.setVisible(true);
	}
	
	// Save the user's selections to the prefs table
	private static void save() {
		// Save download path
		// Try to create the folder if it doesn't exist yet, and throw an error if that fails
		if ( keepSDPSpots.isSelected() ) {
			File newSpotDir = new File(storageFolder.getText());
			if ( ! newSpotDir.exists() || ! newSpotDir.isDirectory() ) {
				// Ask user to confirm folder creation
				int res = JOptionPane.showConfirmDialog(spotPrefs, "The selected spot storage folder, \"" + newSpotDir.getAbsolutePath() + "\", does not exist.  Do you want to create it?", "Confirm Folder Creation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
				if ( res != JOptionPane.YES_OPTION ) return;
				
				if ( ! newSpotDir.mkdirs() ) {
					JOptionPane.showMessageDialog(spotPrefs, "Could not create the selected spot storage folder.  Please choose another one.", "Error Creating Folder", JOptionPane.ERROR_MESSAGE);
					return;
				}
			}
			
			// If we've made it to here, we're good to go - save the spot folder
			SDPConsole.prefs.put(SDP_SPOT_SAVE_LOC, storageFolder.getText());
		}
		
		// Save startup layout
		if ( loadThisLayout.isSelected() ) {
			File newStartLayout = new File(startupLayout.getText());
			if ( ! newStartLayout.exists() || ! newStartLayout.isFile() ) {
				JOptionPane.showMessageDialog(spotPrefs, "The selected startup layout file is not valid.  Please choose another one.", "Invalid Layout File", JOptionPane.ERROR_MESSAGE);
				return;
			}
			
			// If we've made it to here, we're good to go - save the startup layout
			SDPConsole.prefs.put(STARTUP_LAYOUT_LOC, startupLayout.getText());
		}
		
		// Save checkbox states
		SDPConsole.prefs.putBoolean(KEEP_SDP_SPOTS, keepSDPSpots.isSelected());
		SDPConsole.prefs.putBoolean(STARTUP_LAYOUT, loadThisLayout.isSelected());
		
		// Finally, close the dialog
		spotPrefs.setVisible(false);
	}
}
