package com.stereodustparticles.mooler_caster_console;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

// SDP Mooler Caster Console
// Ridiculously simple radio DJ program, with a 16-slot soundboard and 2-deck music player
// Written by Ben A. (IfYouLikeGoodIdeas)

// This class defines the spot download monitor window

public class SpotDownloadMonitor extends JDialog {
	// Default serial version UID to make Java shut up...
	private static final long serialVersionUID = 1L;
	
	// Controls
	JLabel bytesLabel;
	JProgressBar progressBar;
	String bytesText;
	
	public SpotDownloadMonitor(String name) {
		setResizable(false);
		setTitle("Downloading Spot...");
		setBounds(100, 100, 550, 230);
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
		getContentPane().setLayout(null);
		
		JLabel spotLabel = new JLabel("Downloading spot \"" + name + "\"...");
		spotLabel.setBounds(26, 29, 506, 16);
		getContentPane().add(spotLabel);
		
		bytesLabel = new JLabel("Connecting...");
		bytesLabel.setBounds(26, 83, 506, 16);
		getContentPane().add(bytesLabel);
		
		progressBar = new JProgressBar();
		progressBar.setBounds(26, 142, 493, 25);
		getContentPane().add(progressBar);
		
	}
	
	// Set total size to download and reset current progress to 0
	public void setMax(int max) {
		progressBar.setMaximum(max);
		bytesText = " of " + max + " bytes downloaded";
		bytesLabel.setText("0" + bytesText);
	}
	
	// Set current progress
	public void setProgress(int prog) {
		progressBar.setValue(prog);
		bytesLabel.setText(prog + bytesText);
	}
}
