package com.stereodustparticles.mooler_caster_console;

// SDP Mooler Caster Console
// Ridiculously simple radio DJ program, with a 16-slot soundboard and 2-deck music player
// Written by Ben A. (IfYouLikeGoodIdeas)

// This class defines the spot color selection window

import java.awt.Color;
import java.awt.Insets;

import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.JButton;
import javax.swing.JColorChooser;

import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;

public class SpotColorer extends JDialog implements ChangeListener {
	
	// Default UID to make Java shut up!
	private static final long serialVersionUID = 1L;
	
	private JButton preview;
	private JColorChooser chooser;
	
	private Color newColor;
	
	/**
	 * Create the dialog.
	 */
	public SpotColorer(Spot spot) {
		setModalityType(ModalityType.APPLICATION_MODAL);
		setResizable(false);
		setTitle("Set New Spot Color");
		setBounds(100, 100, 462, 480);
		getContentPane().setLayout(null);
		
		// Start with the original color selected
		newColor = spot.getColor();
		
		preview = new JButton(spot.getButton().getText());
		preview.setBounds(186, 25, 89, 89);
		preview.setMargin(new Insets(0, 0, 0, 0));
		setColor(spot.getColor());
		getContentPane().add(preview);
		
		chooser = new JColorChooser();
		if ( spot.getColor() != null ) {
			chooser.setColor(spot.getColor());
		}
		chooser.setBounds(4, 152, 450, 230);
		chooser.setPreviewPanel(new JPanel());
		chooser.getSelectionModel().addChangeListener(this);
		getContentPane().add(chooser);
		
		JButton btnDefaultColor = new JButton("Default Color");
		btnDefaultColor.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setColor(null);
				newColor = null;
			}
		});
		btnDefaultColor.setBounds(166, 407, 125, 23);
		getContentPane().add(btnDefaultColor);
		
		JButton btnOk = new JButton("OK");
		btnOk.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				spot.setColor(newColor); // Take color from preview button so default (null) works
				setVisible(false);
			}
		});
		btnOk.setBounds(71, 407, 89, 23);
		getContentPane().add(btnOk);
		
		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				setVisible(false);
			}
		});
		btnCancel.setBounds(298, 407, 89, 23);
		getContentPane().add(btnCancel);

	}
	
	// Set the color of the preview button
	public void setColor(Color newColor) {
		preview.setBackground(newColor);
		if ( newColor != null && (newColor.getRed() + newColor.getGreen() + newColor.getBlue() < Spot.COLOR_CUTOFF) && newColor.getGreen() < Spot.GREEN_CUTOFF ) {
			preview.setForeground(Color.WHITE);
		}
		else {
			preview.setForeground(Color.BLACK);
		}
	}
	
	// Event handler for the color chooser
	public void stateChanged(ChangeEvent e) {
		setColor(chooser.getColor());
		newColor = chooser.getColor();
	}
}
