package com.stereodustparticles.mooler_caster_console;

import java.awt.Dialog.ModalityType;

import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JSpinner;
import javax.swing.JButton;
import java.awt.event.ItemListener;
import java.io.File;
import java.awt.event.ItemEvent;
import java.awt.event.ActionListener;
import java.awt.event.ActionEvent;
import javax.swing.SpinnerNumberModel;
import javax.swing.JTextField;

// SDP Mooler Caster Console
// Ridiculously simple radio DJ program, with a 16-slot soundboard and 2-deck music player
// Written by Ben A. (IfYouLikeGoodIdeas)

// This class houses the Deck Preferences dialog

public class DeckPrefs {
	
	// ** KEYS AND DEFAULT VALUES FOR DECK PREFERENCES **
	public static final String FLASH_TIMERS = "Flash_Deck_Timers";
	public static final boolean DEFAULT_FLASH_TIMERS = true;
	
	public static final String FLASH_POINT = "Flash_Deck_Timers_At";
	public static final int DEFAULT_FLASH_POINT = 30;
	
	public static final String LOG_ENABLED = "Playlist_Log_Enabled";
	public static final boolean DEFAULT_LOG_ENABLED = false;
	
	public static final String LOG_DIR = "Playlist_Log_Dir";
	public static final String DEFAULT_LOG_DIR = System.getProperty("user.home") + File.separator + "SDP_Playlists";
	
	// GUI crap
	private static JDialog deckPrefs;
	private static JCheckBox flashEnable;
	private static JSpinner flashTime;
	private static JCheckBox logEnable;
	private static JTextField logDir;
	
	/**
	 * Initialize the dialog
	 * @wbp.parser.entryPoint
	 */
	public static void initialize() {
		
		deckPrefs = new JDialog();
		
		deckPrefs.setResizable(false);
		deckPrefs.setTitle("Deck Preferences");
		deckPrefs.setModalityType(ModalityType.APPLICATION_MODAL);
		deckPrefs.setModal(true);
		deckPrefs.setBounds(100, 100, 440, 285);
		deckPrefs.getContentPane().setLayout(null);
		
		// Flashing Timers
		JLabel lblTimeAtWhich = new JLabel("Start flashing at:");
		lblTimeAtWhich.setEnabled(false);
		lblTimeAtWhich.setBounds(17, 68, 109, 14);
		deckPrefs.getContentPane().add(lblTimeAtWhich);
		
		flashTime = new JSpinner();
		flashTime.setModel(new SpinnerNumberModel(0, 0, null, 1));
		flashTime.setEnabled(false);
		flashTime.setBounds(136, 65, 50, 20);
		deckPrefs.getContentPane().add(flashTime);
		
		JLabel lblSecondsRemaining = new JLabel("seconds remaining");
		lblSecondsRemaining.setEnabled(false);
		lblSecondsRemaining.setBounds(196, 68, 133, 14);
		deckPrefs.getContentPane().add(lblSecondsRemaining);
		
		flashEnable = new JCheckBox("Flash the deck's timer when the playing song is reaching its end");
		flashEnable.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if ( e.getStateChange() == ItemEvent.SELECTED ) {
					lblTimeAtWhich.setEnabled(true);
					flashTime.setEnabled(true);
					lblSecondsRemaining.setEnabled(true);
				}
				else {
					lblTimeAtWhich.setEnabled(false);
					flashTime.setEnabled(false);
					lblSecondsRemaining.setEnabled(false);
				}
			}
		});
		flashEnable.setBounds(17, 28, 399, 23);
		deckPrefs.getContentPane().add(flashEnable);
		
		JLabel lblLogDirectory = new JLabel("Log directory:");
		lblLogDirectory.setEnabled(false);
		lblLogDirectory.setBounds(17, 161, 89, 16);
		deckPrefs.getContentPane().add(lblLogDirectory);
		
		logDir = new JTextField();
		logDir.setEnabled(false);
		logDir.setBounds(103, 158, 211, 22);
		deckPrefs.getContentPane().add(logDir);
		logDir.setColumns(10);
		
		JButton btnBrowse = new JButton("Browse...");
		btnBrowse.setEnabled(false);
		btnBrowse.setBounds(319, 157, 97, 25);
		btnBrowse.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				// Load a JFileChooser to use to select a folder
				JFileChooser chooser = new JFileChooser();
				
				chooser.setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
				chooser.setCurrentDirectory(new File(logDir.getText()));
				
				int res = chooser.showOpenDialog(deckPrefs);
				
				if ( res != JFileChooser.CANCEL_OPTION ) {
					logDir.setText(chooser.getSelectedFile().getAbsolutePath());
				}
			}
		});
		deckPrefs.getContentPane().add(btnBrowse);
		
		logEnable = new JCheckBox("Create a log of all songs played on the decks");
		logEnable.setBounds(17, 123, 399, 25);
		logEnable.addItemListener(new ItemListener() {
			public void itemStateChanged(ItemEvent e) {
				if ( e.getStateChange() == ItemEvent.SELECTED ) {
					lblLogDirectory.setEnabled(true);
					logDir.setEnabled(true);
					btnBrowse.setEnabled(true);
				}
				else {
					lblLogDirectory.setEnabled(false);
					logDir.setEnabled(false);
					btnBrowse.setEnabled(false);
				}
			}
		});
		deckPrefs.getContentPane().add(logEnable);
		
		JButton btnSave = new JButton("Save");
		btnSave.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				save();
			}
		});
		btnSave.setBounds(75, 214, 89, 23);
		deckPrefs.getContentPane().add(btnSave);
		
		JButton btnCancel = new JButton("Cancel");
		btnCancel.addActionListener(new ActionListener() {
			public void actionPerformed(ActionEvent e) {
				deckPrefs.setVisible(false);
			}
		});
		btnCancel.setBounds(274, 214, 89, 23);
		deckPrefs.getContentPane().add(btnCancel);
	}
	
	// Show the deck preferences dialog
	public static void show() {
		flashEnable.setSelected(SDPConsole.prefs.getBoolean(FLASH_TIMERS, DEFAULT_FLASH_TIMERS));
		flashTime.setValue(SDPConsole.prefs.getInt(FLASH_POINT, DEFAULT_FLASH_POINT));
		
		logEnable.setSelected(SDPConsole.prefs.getBoolean(LOG_ENABLED, DEFAULT_LOG_ENABLED));
		logDir.setText(SDPConsole.prefs.get(LOG_DIR, DEFAULT_LOG_DIR));
		
		deckPrefs.setVisible(true);
	}
	
	// Save settings
	private static void save() {
		// Check existence of log directory and create it if needed
		if ( logEnable.isSelected() ) {
			File newLogDir = new File(logDir.getText());
			if ( ! newLogDir.exists() || ! newLogDir.isDirectory() ) {
				// Ask user to confirm folder creation
				int res = JOptionPane.showConfirmDialog(deckPrefs, "The selected log directory, \"" + newLogDir.getAbsolutePath() + "\", does not exist.  Do you want to create it?", "Confirm Folder Creation", JOptionPane.YES_NO_OPTION, JOptionPane.QUESTION_MESSAGE);
				if ( res != JOptionPane.YES_OPTION ) return;
				
				if ( ! newLogDir.mkdirs() ) {
					JOptionPane.showMessageDialog(deckPrefs, "Could not create the selected log directory.  Please choose another one.\n\nIf the problem persists, throw your computer into the pool.", "Error Creating Folder", JOptionPane.ERROR_MESSAGE);
					return;
				}
			}
			
			// If we've made it to here, we're good to go - save the log dir
			SDPConsole.prefs.put(LOG_DIR, logDir.getText());
		}
		
		// Update logging enabled value
		SDPConsole.prefs.putBoolean(LOG_ENABLED, logEnable.isSelected());
		
		// Update flash settings
		SDPConsole.prefs.putBoolean(FLASH_TIMERS, flashEnable.isSelected());
		SDPConsole.prefs.putInt(FLASH_POINT, (int)flashTime.getValue());
		
		// Update settings in currently active decks
		Deck.flashPoint = (int)flashTime.getValue() * 10;
		Deck.shouldFlash = flashEnable.isSelected();
		Deck.logDirectory = new File(logDir.getText());
		Deck.shouldLog = logEnable.isSelected();
		
		deckPrefs.setVisible(false);
	}
}
