package com.stereodustparticles.mooler_caster_console;

import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;

// SDP Mooler Caster Console
// Ridiculously simple radio DJ program, with a 16-slot soundboard and 2-deck music player
// Written by Ben A. (IfYouLikeGoodIdeas)

// This class specifies the board load status window

public class BoardLoadStatus extends JDialog {

	// Default serial version UID to make Java shut up...
	private static final long serialVersionUID = 1L;
	
	// Dynamic controls
	private JLabel lblSpot;
	private JProgressBar progressBar;

	/**
	 * Create the dialog.
	 */
	public BoardLoadStatus(String layoutName) {
		setResizable(false);
		setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
		setTitle("Restoring Soundboard Layout...");
		setBounds(100, 100, 600, 200);
		getContentPane().setLayout(null);
		
		JLabel lblLayout = new JLabel("Restoring layout \"" + layoutName + "\", please wait...");
		lblLayout.setBounds(24, 32, 560, 14);
		getContentPane().add(lblLayout);
		
		lblSpot = new JLabel("Loading spot \"\"...");
		lblSpot.setBounds(24, 76, 560, 14);
		getContentPane().add(lblSpot);
		
		progressBar = new JProgressBar();
		progressBar.setBounds(24, 124, 547, 22);
		getContentPane().add(progressBar);
	}
	
	// Set the spot name in the lower label
	public void setCurrentSpot(String spot) {
		lblSpot.setText("Loading spot \"" + spot + "\"...");
	}
	
	// Set the max value of the progress bar (i.e. where's 100%)
	public void setProgressMax(int max) {
		progressBar.setMaximum(max);
	}
	
	// Set the current value of the progress bar
	public void setCurrentProgress(int prog) {
		progressBar.setValue(prog);
	}
}
