<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	//Custom error handler
	function eh($errno, $errstr, $errfile, $errline)
	{
		switch ($errno)
		{
			case E_USER_WARNING:
			echo "<b><u>WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_USER_NOTICE:
			echo "<b><u>NOTICE:</u></b> " . $errstr . "<br><br>\n";
			break;
			
			case E_WARNING:
			echo "<b><u>PHP WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_NOTICE:
			break;

			default:
			echo "Unhandled error.<br><br>\n";
			break;
    	}

    	/* Don't execute PHP internal error handler */
    	return true;
	}
	//Set error handler to the custom one
	$oeh=set_error_handler("eh");
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-View Log</title>
	<script type="text/javascript" src="backend/jquery.js"></script>
	<script type="text/javascript" src="backend/tablesorter.js"></script>
	<link rel="stylesheet" href="backend/tsstyle/style.css" type="text/css" media="print, projection, screen" />
	<script type="text/javascript">
	$(function() {
		$("#logtable").tablesorter();
	});
	</script>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
	
	table,th,td { border: 1px solid #000000; }
    -->
    </style>
  </head>
<?php
	if(isset($_GET['log']) && $_GET['log'] != "")
	{
		//Sanitize log number!
		$log=preg_replace("/[^0-9]/", "", $_GET['log']);
		//Display a log file
		if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes" && date("Ymd") != $log)
		{
			//Logging is enabled, and the log file the user is viewing is not the present one
			$ip=$_SERVER['REMOTE_ADDR'];
			$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			//Check whether the log file exists or not
			if(file_exists("log/" . $log . ".txt"))
			{
				$logcontents=file_get_contents("log/" . $log . ".txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got contents of log file\r\n");
			}
			else
			{
				$logcontents="";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Failed to get contents of log file; does not exist\r\n");
			}
			fclose($fh);
		}
		else
		{
			//Check whether the log file exists or not
			if(file_exists("log/" . $log . ".txt"))
			{
				$logcontents=file_get_contents("log/" . $log . ".txt");
			}
			else
			{
				$logcontents="";
			}
		}
	}
	else
	{
		if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			$ip=$_SERVER['REMOTE_ADDR'];
			$date=date("g:i:s");
			$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			fwrite($fh,$ip . " at " . $date . ": Visited logfile viewing page\r\n");
			if(securitycheck() === false)
			{
				//User is not administrator
				fclose($fh);
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			}
			//Get list of all logs
			$logs1=glob("log/*.txt");
			$logs=array();
			if(count($logs1) >= 1)
			{
				foreach($logs1 as $log)
				{
					$logs[]=substr($log,4,-4);
				}
			}
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Got list of all logs\r\n");
			fclose($fh);
		}
		else
		{
			if(securitycheck() === false)
			{
				//User is not administrator
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			}
			//Get list of all logs
			$logs1=glob("log/*.txt");
			$logs=array();
			if(count($logs1) >= 1)
			{
				foreach($logs1 as $log)
				{
					$logs[]=substr($log,4,-4);
				}
			}
		}
	}
?>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>MRS-View Logfile</h1>
  <?php
	//Check if log file needs displaying
	if(isset($logcontents) && $logcontents != "")
	{
		//Split logfile into log entries
		$logcontents=explode("\r\n",$logcontents);
		//Begin outputting table
		echo ("<table id=\"logtable\" class=\"tablesorter\">\r\n<thead>\r\n<tr>\r\n<th>IP Address</th>\r\n<th>Time (hh:mm:ss)</th>\r\n<th>Action</th>\r\n</tr>\r\n</thead>\r\n<tbody>\r\n");
		//Loop through list of contents
		foreach($logcontents as $entry)
		{
			//Verify that entry is non-blank
			if($entry != "")
			{
				//Create row
				echo ("<tr>\r\n");
				//Output IP address into cell
				echo ("<td>" . substr($entry,0,strpos($entry,"at")-1) . "</td>\r\n");
				//Get time and format it
				$time=strtotime(substr($entry,strpos($entry,"at")+3,(strpos($entry,": ")-strpos($entry,"at")-3)));
				//Output time into cell
				echo ("<td>" . date("g:i:s A",$time) . "</td>\r\n");
				//Output action into cell
				echo ("<td>" . substr($entry,strpos($entry,": ")+2) . "</td>\r\n");
				//Close row
				echo ("</tr>\r\n");
			}
		}
		//End table output
		echo ("</tbody>\r\n</table>\r\n");
	}
	else
	{
		//Display form for selecting logfile to display
		echo ("<form method=\"get\" action=\"viewlog.php\">\r\nSelect the log you wish to view:&nbsp;\r\n<select name=\"log\">\r\n<option value=\"\">-Select one-</option>\r\n");
		foreach($logs as $log)
		{
			echo ("<option value=\"" . $log . "\">" . $log . "</option>\r\n");
		}
		echo ("</select><br>\r\n<input type=\"submit\"><input type=\"button\" value=\"Cancel\" onclick=\"window.location.href='index.php'\">\r\n</form>\r\n");
	}
  ?>
  </body>
</html>