<?php
	//Open session
	session_start();
?>
<?php
	//Version identifier class (to make things easy)
	class Version
	{
		public $major=0;
		public $minor=0;
		public $revision=0;
		public $beta=false;
		public $identifier="";
		public $built="January 1, 1970 at 12:00 AM Eastern Time";
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("../backend/securitycheck.php"))
	{
		include ("../backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"../backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="../backend/favicon.ico">
    <title> Music Request System-Check For Updates</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('../backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <?php
	$current=new Version;
	$new=new Version;
	if(file_exists("../backend/logging.txt") && file_get_contents("../backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("../log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"../log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		$date=date("g:i:s");
		fwrite($fh,$ip . " at " . $date . ": Viewed update check page\r\n");
		//Check for administrative permissions
		if(securitycheck() === false)
		{
			//No admin privileges, no page viewing privileges
			fclose($fh);
			die("You are not an administrator. <a href=\"../login.php\">Sign in</a> or <a href=\"../index.php\">Cancel</a>.");
		}
		//Check for a version file
		if(file_exists("../backend/version.txt"))
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained version information\r\n");
			//Read file
			$data=explode("\r\n",file_get_contents("../backend/version.txt"));
			//Assign known parameters to the version object
			$current->identifier=$data[1];
			$current->built=$data[2];
			//Obtain and set further version information
			$data[0]=explode("|",$data[0]);
			$current->major=$data[0][0];
			$current->minor=$data[0][1];
			$current->revision=$data[0][2];
			switch($data[0][3])
			{
				case "1":
				$current->beta=true;
				break;
				default:
				$current->beta=false;
				break;
			}
		}
		else
		{
			//Cannot read file
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Could not obtain version information\r\n");
			echo ("Failed to open file \"backend/version.txt\" in read mode. It should now be microwaved.<br>\r\n");
		}
		//Initialize curl
		$curl=curl_init();
		$check=-1;
		if($curl !== false)
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Initialized CURL to get latest version information\r\n");
			//Set curl options
			if(file_exists("../backend/stable.txt") && file_get_contents("../backend/stable.txt") == "yes")
			{
				curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-stable.txt");
			}
			else
			{
				curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest.txt");
			}
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_HEADER, false);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Set curl options\r\n");
			//Execute curl
			$data = curl_exec($curl);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Executed curl\r\n");
			
			//Check and form the data
			if($data != "" && !curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Successfully executed curl\r\n");
				$data=explode("|",$data);
				$new->major=$data[0];
				$new->minor=$data[1];
				$new->revision=$data[2];
				switch($data[3])
				{
					case "1":
					$new->beta=true;
					break;
					default:
					$new->beta=false;
					break;
				}
				
				//Check if current version is a beta
				if($current->beta === true)
				{
					//Current version is a beta, check if new version is a beta
					if($new->beta === true)
					{
						//New version is a beta, if new version is greater it is automatically treated as a new beta release
						if($new->major > $current->major || $new->minor > $current->minor || $new->revision > $current->revision)
						{
							$check=4;
						}
						else
						{
							//Nothing new
							$check=0;
						}
					}
					else
					{
						//New version is not a beta, if new version is greater it is automatically treated as an important upgrade
						if($new->major > $current->major || $new->minor > $current->minor || $new->revision > $current->revision)
						{
							$check=1;
						}
						elseif($new->major == $current->major && $new->minor == $current->minor && $new->revision == $current->revision)
						{
							//Revision status is upped to stable
							$check=3;
						}
					}
				}
				else
				{
					//Current version is not a beta, check if new version is a beta
					if($new->beta === true)
					{
						//New version is a beta, if new version is greater it is automatically treated as a new beta release
						if($new->major > $current->major || $new->minor > $current->minor || $new->revision > $current->revision)
						{
							$check=4;
						}
						else
						{
							//Nothing new
							$check=0;
						}
					}
					else
					{
						//New version is not a beta, check if major or minor numbers are greater
						if($new->major > $current->major || $new->minor > $current->minor)
						{
							//New release issued
							$check=1;
						}
						elseif($new->revision > $current->revision)
						{
							//New revision issued
							$check=2;
						}
						else
						{
							//Nothing new
							$check=0;
						}
					}
				}
			}
			else
			{
				//Curl failed
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Failed to execute curl, error: " . curl_errno($curl) . "\r\n");
				echo ("Failed to open remote file \"latest.txt\" in read mode. The remote server should be submerged in pool water.<br>\r\n");
			}
			//Close session
			curl_close($curl);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Closed curl session\r\n");
			fclose($fh);
		}
	}
	else
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging disabled
		//Check for administrative permissions
		if(securitycheck() === false)
		{
			//No admin privileges, no page viewing privileges
			die("You are not an administrator. <a href=\"../login.php\">Sign in</a> or <a href=\"../index.php\">Cancel</a>.");
		}
		//Check for a version file
		if(file_exists("../backend/version.txt"))
		{
			//Read file
			$data=explode("\r\n",file_get_contents("../backend/version.txt"));
			//Assign known parameters to the version object
			$current->identifier=$data[1];
			$current->built=$data[2];
			//Obtain and set further version information
			$data[0]=explode("|",$data[0]);
			$current->major=$data[0][0];
			$current->minor=$data[0][1];
			$current->revision=$data[0][2];
			switch($data[0][3])
			{
				case "1":
				$current->beta=true;
				break;
				default:
				$current->beta=false;
				break;
			}
		}
		else
		{
			//Cannot read file
			echo ("Failed to open file \"backend/version.txt\" in read mode. It should now be microwaved.<br>\r\n");
		}
		//Initialize curl
		$curl=curl_init();
		$check=-1;
		if($curl !== false)
		{
			//Set curl options
			if(file_exists("../backend/stable.txt") && file_get_contents("../backend/stable.txt") == "yes")
			{
				curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-stable.txt");
			}
			else
			{
				curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest.txt");
			}
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_HEADER, false);
			//Execute curl
			$data = curl_exec($curl);
			
			//Check and form the data
			if($data != "" && !curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
			{
				$data=explode("|",$data);
				$new->major=$data[0];
				$new->minor=$data[1];
				$new->revision=$data[2];
				switch($data[3])
				{
					case "1":
					$new->beta=true;
					break;
					default:
					$new->beta=false;
					break;
				}
				
				//Check if current version is a beta
				if($current->beta === true)
				{
					//Current version is a beta, check if new version is a beta
					if($new->beta === true)
					{
						//New version is a beta, if new version is greater it is automatically treated as a new beta release
						if($new->major > $current->major || $new->minor > $current->minor || $new->revision > $current->revision)
						{
							$check=4;
						}
						else
						{
							//Nothing new
							$check=0;
						}
					}
					else
					{
						//New version is not a beta, if new version is greater it is automatically treated as an important upgrade
						if($new->major > $current->major || $new->minor > $current->minor || $new->revision > $current->revision)
						{
							$check=1;
						}
						elseif($new->major == $current->major && $new->minor == $current->minor && $new->revision == $current->revision)
						{
							//Revision status is upped to stable
							$check=3;
						}
					}
				}
				else
				{
					//Current version is not a beta, check if new version is a beta
					if($new->beta === true)
					{
						//New version is a beta, if new version is greater it is automatically treated as a new beta release
						if($new->major > $current->major || $new->minor > $current->minor || $new->revision > $current->revision)
						{
							$check=4;
						}
						else
						{
							//Nothing new
							$check=0;
						}
					}
					else
					{
						//New version is not a beta, check if major or minor numbers are greater
						if($new->major > $current->major || $new->minor > $current->minor)
						{
							//New release issued
							$check=1;
						}
						elseif($new->revision > $current->revision)
						{
							//New revision issued
							$check=2;
						}
						else
						{
							//Nothing new
							$check=0;
						}
					}
				}
			}
			else
			{
				//Curl failed
				echo ("Failed to open remote file \"latest.txt\" in read mode. The remote server should be submerged in pool water.<br>\r\n");
			}
			//Close session
			curl_close($curl);
		}
	}
  ?>
<?php
	/* OLD CODE included for reference
	$current=array("0","0","0",false);
	if(file_exists("../backend/version.txt"))
	{
		$data=explode("\r\n",file_get_contents("../backend/version.txt"));
		$current=explode("|",$data[0]);
		switch($current[3])
		{
			case "1":
			$current[3]=true;
			break;
			default:
			$current[3]=false;
			break;
		}
	}
	//initialize latest version header
	$new=array("0","0","0",false);
	if(file_exists("../backend/logging.txt") && file_get_contents("../backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("../log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"\". It should now be microwaved..");
		//Only show page if user is an administrator
		$date=date("g:i:s");
		fwrite($fh,$ip . " at " . $date . ": Viewed update check page\r\n");
		if(securitycheck() === false)
		{
			fclose($fh);
			die("You are not an administrator. <a href=\"../login.php\">Sign in</a> or <a href=\"../index.php\">Cancel</a>.");
		}
		//Initialize curl
		$curl=curl_init();
		$check=-1;
		if($curl !== false)
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Initialized CURL to get latest version information\r\n");
			//Set curl options
			curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest.txt");
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_HEADER, false);
			curl_setopt($curl, CURLOPT_CONNECTTIMEOUT, 10000);
			curl_setopt($curl, CURLOPT_TIMEOUT, 20000);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Set curl options\r\n");
			//Execute curl
			$data = curl_exec($curl);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Executed curl\r\n");
			
			//Check and form the data
			if($data != "" && !curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Successfully executed curl\r\n");
				$data=explode("|",$data);
				$new=$data;
				switch($new[3])
				{
					case "1":
					$new[3]=true;
					break;
					default:
					$new[3]=false;
					break;
				}
				
				if(($current[0] != $new[0] || $current[1] != $new[1]) && $new[3] === false)
				{
					//New major/minor version
					$check=1;
				}
				elseif($current[2] != $new[2] && $new[3] === false)
				{
					//New revision
					$check=2;
				}
				elseif($current[3] === true && $new[3] === false)
				{
					//Stable release when running non-stable release
					$check=1;
				}
				elseif(($current[0] != $new[0] || $current[1] != $new[1] || $current[2] != $new[2]) && $new[3] !== false)
				{
					//New beta release
					$check=3;
				}
				else
				{
					//No new release
					$check=0;
				}
			}
			else
			{
				//Curl failed
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Failed to execute curl, error: " . curl_errno($curl) . "\r\n");
				fclose($fh);
			}
			//Close session
			curl_close($curl);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Closed curl session\r\n");
			fclose($fh);
		}
	}
	else
	{
		//Only show page if user is an administrator
		if(securitycheck() === false)
		{
			die("You are not an administrator. <a href=\"../login.php\">Sign in</a> or <a href=\"../index.php\">Cancel</a>.");
		}
		//Initialize curl
		$curl=curl_init();
		$check=-1;
		if($curl !== false)
		{
			//Set curl options
			curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest.txt");
			curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($curl, CURLOPT_HEADER, false);
			//Execute curl
			$data = curl_exec($curl);
			
			//Check and form the data
			if($data != "" && !curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
			{
				$data=explode("|",$data);
				$new=$data;
				switch($new[3])
				{
					case "1":
					$new[3]=true;
					break;
					default:
					$new[3]=false;
					break;
				}
				
				if(($current[0] != $new[0] || $current[1] != $new[1]) && $new[3] === false)
				{
					//New major/minor version
					$check=1;
				}
				elseif($current[2] != $new[2] && $new[3] === false)
				{
					//New revision
					$check=2;
				}
				elseif($current[3] === true && $new[3] === false)
				{
					//Stable release when running non-stable release
					$check=1;
				}
				elseif(($current[0] != $new[0] || $current[1] != $new[1] || $current[2] != $new[2]) && $new[3] !== false)
				{
					//New beta release
					$check=3;
				}
				else
				{
					//No new release
					$check=0;
				}
			}
			//Close session
			curl_close($curl);
		}
	}*/
?>
<?php
	//FOR DEBUGGING PURPOSES ONLY!
	//$check=4;
?>
  <body>
  <h1 style="text-align:center; text-decoration:underline;">MRS-Upgrade System</h1>
  <h2>First, A Word About Automatic Upgrades</h2>
  <p>The latest upgrade packages of the MRS can be obtained <a href="http://firealarms.redbat.ca/mrs/upgrade-packs.html">here</a>. Note that full install packages <b>cannot</b> be used by the automatic upgrade scripts. If you do not download a package, it will download it for you.<br>
  This file MUST be named "latest.zip" and MUST be placed in the "upgrade" directory. Failing to do so will result in the system downloading the package instead, completely ignoring what you have uploaded to it, and the cleanup burden will be on you.<br>
  Also note that if you are not upgrading to the latest version (stable or beta standing does NOT matter), the appropriate MD5 MUST also be located here, named "latest-md5.txt". Not doing so will cause the upgrade process to fail instantly!</p>
  <p><b>NOTE</b>: when running the upgrade script, the page may remain in a loading state for a long time. <b><u>DO NOT INTERRUPT THIS PROCESS!</u></b> Interrupting the process <b>WILL</b> result in system breakage!</p>
  <p>If you choose to use the automatic upgrading system provided for below, you have two options: one will retain all settings, the other will overwrite them with the defaults.<br>
  The destructive option has <u>no</u> effect on posts, song lists, rule lists, passwords. It will, however, overwrite the background and the browser favicon in addition to system settings.<br>
  <b>EVEN if you chose the non-destructive option, keep a good backup of your system!</b> No one knows what will happen in the event of an unforseen problem or a bug in the upgrade scripts (very possible with beta releases, not as likely but still possible with stable ones)! You may be sorry later if you don't!</p>
  <h2>Upgrading Manually</h2>
  <p>When you download the latest "upgrade package" from , you should extract it into a clean folder. In it, you'll find all the PHP files (&lt;filename&gt;.php), two image files: background.gif and favicon.ico, and two text files: "config.txt" and "version.txt".</p>
  <p>To upgrade, copy all the PHP files over top of the existing files in the root of the MRS, and copy "version.txt" over top of the existing version.txt in the backend folder. You may choose to copy background.gif and/or favicon.ico over top of the existing ones, or you may not.<br>
  Read the config.txt file. In it, you'll find a list of configuration files and their default values (in the format "config item|default value"). For each item, create (or overwrite) a text file in the backend directory with the configuration's name and put the default value in it. If you want to keep your existing configuration, do not overwrite existing files!</p>
  <p><b>NOTE: DO NOT TOUCH ANY FILE NOT LISTED IN config.txt IF YOU ARE UNSURE OF ITS PURPOSE!</b> If you are reasonably sure they are just obsolete configuration files, you may then delete them, but the results are your responsibility. Deleting anything that does not have a .txt extension WILL break all or part of the system.</p>
  <h2>Before Upgrading Your PHP Install</h2>
  <p><b><u>The administrator password IS NOT GUARANTEED to be portable across PHP versions!</u></b> For security purposes, reset tools are not included and not published by default. If you find you can no longer log in to the MRS admin console, you MUST <a href="http://firealarms.redbat.ca/contact.php">contact the software vendor</a> and request a password reset script! Alternative methods are possible but not supported, and are attempted at one's own risk.</p>
  <h2>Alright, Let's Actually Get Upgrading!</h2>
  <p>The version of the MRS presently running is <?php echo $current->major . "." . $current->minor . ", revision " . $current->revision; ?>. <?php if ($current->beta === true) { echo "This is a beta release."; } ?><br>
  The latest version of the MRS is <?php echo $new->major . "." . $new->minor . ", revision " . $new->revision; ?>. <?php if ($new->beta === true) { echo "This is a beta release."; } ?></p>
  <p>
  <?php
	switch($check)
	{
		case 0:
		//Nothing new
		echo ("You are running the latest MRS already.");
		if(file_exists("latest.zip") && file_exists("latest-md5.txt"))
		{
			echo (" Upgrading is not necessary, but the system has noted the presence of both an upgrade package and an MD5 hash file. You may force an upgrade using these files. <a href=\"keep.php\">Force upgrade keeping settings</a>, or <a href=\"destroy.php\">Force upgrade erasing settings</a>.");
		}
		else
		{
			echo (" Upgrading is not necessary. You may force an upgrade, but it is required that you have both an upgrade package and the matching MD5 hash file present on the system. The system has detected one or both of these are missing. Please download them to proceed.");
		}
		break;
		case 1:
		//New release
		echo ("There is a new release of the MRS available. Upgrading is strongly recommended. <a href=\"keep.php\">Upgrade keeping settings</a>, <a href=\"destroy.php\">Upgrade erasing settings</a>, or <a href=\"http://firealarms.redbat.ca/mrs/index.html#changelog\" target=\"_blank\">View the changelog</a> (opens in a new tab/window).");
		break;
		case 2:
		//New revision
		echo ("There is a new revision of the MRS available. Upgrading is not necessary, however there may be security enhancements and desirable new features to be gained. <a href=\"keep.php\">Upgrade keeping settings</a>, <a href=\"destroy.php\">Upgrade erasing settings</a>, or <a href=\"http://firealarms.redbat.ca/mrs/index.html#changelog\" target=\"_blank\">View the changelog</a> (opens in a new tab/window).");
		break;
		case 3:
		//Revision upped to stable status
		echo ("The beta release you are running has been upgraded to stable status. There may be important changes, so running an upgrade cycle is strongly recommended. <a href=\"keep.php\">Upgrade keeping settings</a>, <a href=\"destroy.php\">Upgrade erasing settings</a>, or <a href=\"http://firealarms.redbat.ca/mrs/index.html#changelog\" target=\"_blank\">View the changelog</a> (opens in a new tab/window).");
		break;
		case 4:
		//New beta
		echo ("A new beta release is available. Upgrades are discouraged on production systems due to the increase in bugs potentially in such a release. <a href=\"keep.php\">Upgrade anyways, keeping settings</a>, <a href=\"destroy.php\">upgrade anyways, erasing settings</a>, or <a href=\"http://firealarms.redbat.ca/mrs/index.html#changelog\" target=\"_blank\">View the changelog</a> (opens in a new tab/window).");
		break;
		default:
		echo ("There was an error somewhere along the line. The system is probably partially submerged in a pool somewhere. You may proceed with an upgrade, but doing so is AT YOUR OWN RISK! <a href=\"keep.php\">Force upgrade keeping settings</a>, or <a href=\"destroy.php\">Force upgrade erasing settings</a>.");
		break;
	}
  ?>
  </p>
  <p><a href="../admin.php">Go back</a></p>
  </body>
</html>