<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("../backend/securitycheck.php"))
	{
		include ("../backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"../backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="../backend/favicon.ico">
    <title> Music Request System-Upgrade System</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('../backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;">MRS-Upgrade System</h1>
  <p>
  <?php
    /* Methodology
    Verify MD5
    Make temporary directory
    Extract zip archive
    Overwrite PHP files
	Overwrite background and favicon
    Enumerate existing config files
    Enumerate new config files
    Delete obsolete config files
    Install previously-nonexisting config files
    Overwrite version file
    Overwrite upgrade scripts */
    $terminate=0;
    if(file_exists("../backend/logging.txt") && file_get_contents("../backend/logging.txt") == "yes")
    {
        $ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("../log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"../log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved..");
		//Only show page if user is an administrator
		$date=date("g:i:s");
		fwrite($fh,$ip . " at " . $date . ": Attempted to begin system upgrade (reset settings)\r\n");
        if(securitycheck() === false)
		{
			fclose($fh);
			die("You are not an administrator. <a href=\"../login.php\">Sign in</a> or <a href=\"../index.php\">Cancel</a>.");
		}
		//Download ZIP (if needed)
		if(!file_exists("latest.zip"))
		{
			echo ("Package required for updating not found, attempting to download...");
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": No local pack found, using CURL to get latest upgrade pack\r\n");
			//Open zip file
			$dfh=fopen("latest.zip",'w+');
			if($dfh)
			{
				//Initialize curl
				$curl=curl_init();
				$check=-1;
				if($curl !== false)
				{
					//Set curl options
					if(file_exists("../backend/stable.txt") && file_get_contents("../backend/stable.txt") == "yes")
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-stable.zip");
					}
					else
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest.zip");
					}
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_BINARYTRANSFER, true);
					curl_setopt($curl, CURLOPT_FILE,$dfh);
					curl_setopt($curl, CURLOPT_HEADER, false);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Set curl options\r\n");
					//Execute curl
					curl_exec($curl);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Executed curl\r\n");
					
					//Check and form the data
					if(!curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
					{
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Successfully executed curl\r\n");
						echo ("DONE.<br>\r\n");
					}
					else
					{
						//Curl failed
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Failed to execute curl, error: " . curl_errno($curl) . "\r\n");
						echo ("FAILED, error code " . curl_errno($curl) . ", HTTP response code " . curl_getinfo($curl,CURLINFO_HTTP_CODE) . ". Contact the software vendor and threaten to microwave their microphone.<br>\r\n");
						$cfail=true;
					}
					//Close session
					curl_close($curl);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Closed curl session\r\n");
					fclose($dfh);
				}
			}
			else
			{
				//Cannot open the file for writing.
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Cannot open file\r\n");
				echo ("FAILED, unable to save file. Submerge the upgrade directory in pool water.<br>\r\n");
			}
		}
		//Delete leftover traces if curl failed and file didn't exist beforehand
		if(isset($cfail) && $cfail === true)
		{
			unlink("latest.zip");
		}
		//Verify that the file does exist
		$date=date("g:i:s");
		fwrite($fh,$ip . " at " . $date . ": Verifying upgrade file exists\r\n");
		echo ("Double-checking to make sure the required package exists...");
		if(file_exists("latest.zip"))
		{
			//Exists
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Verifying upgrade file exists\r\n");
			echo ("DONE.<br>\r\n");
		}
		else
		{
			//Doesn't exist
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Verifying upgrade file exists\r\n");
			echo ("FAILED. Either you had ONE JOB and didn't name the file correctly (it should be \"latest.zip\"), or the server needs to be microwaved.<br>\r\n");
			$terminate=1;
		}
		//Proceed after error handling
		if($terminate != 1)
		{
			//Verify MD5 sums
			echo ("Calculating MD5 hash of local ZIP archive...");
			$md5local=md5_file("latest.zip");
			echo ("DONE. MD5 hash: " . $md5local . "<br>\r\n");
			//Download MD5 hash from home server
			echo ("Downloading MD5 hash comparison file...");
			$md5remote=false;
			if(!file_exists("latest-md5.txt"))
			{
				//Initialize curl
				$curl=curl_init();
				$check=-1;
				if($curl !== false)
				{
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Mo local file found, using CURL to get latest version MD5\r\n");
					//Set curl options
					if(file_exists("../backend/stable.txt") && file_get_contents("../backend/stable.txt") == "yes")
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-stable-md5.txt");
					}
					else
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-md5.txt");
					}
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_HEADER, false);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Set curl options\r\n");
					//Execute curl
					$data = curl_exec($curl);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Executed curl\r\n");
					
					//Check and form the data
					if($data != "" && !curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
					{
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Successfully executed curl\r\n");
						$md5remote=$data;
						echo ("DONE. MD5 hash:" . $md5remote . "<br>\r\n");
					}
					else
					{
						//Curl failed
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Failed to execute curl, error: " . curl_errno($curl) . "\r\n");
						echo ("FAILED.<br>\r\n");
					}
					//Close session
					curl_close($curl);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Closed curl session\r\n");
				}
			}
			else
			{
				//Local MD5 exists
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Getting latest version MD5 from local file\r\n");
				$md5remote=file_get_contents("latest-md5.txt");
			}
			//Make sure MD5s match
			echo ("Checking MD5 hashes...");
			if($md5remote !== false && $md5remote != "" && $md5local == $md5remote)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Matched MD5 sums\r\n");
				echo ("DONE. Checksums matched, proceeding with upgrade.<br>\r\n");
			}
			elseif($md5remote == "" || $md5remote === false)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Remote MD5 blank, skipping check\r\n");
				echo ("SKIPPED. No MD5 to compare to. Proceeding with upgrade, expect problems.<br>\r\n");
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": MD5s do not match, aborting upgrade\r\n");
				echo("DONE. MD5s do NOT match, aborting upgrade process. Please re-download the MRS upgrade package, or contact the software vendor.<br>\r\n");
				$terminate=1;
			}
		}
		if($terminate != 1)
		{
			//Proceed with upgrade process
			//Create blank directory
			echo ("Creating temporary extraction directory...");
			$debug=mkdir("temp");
			if($debug === true)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": created temporary extraction directory\r\n");
				echo ("DONE.<br>\r\n");
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": failed to create temporary extraction directory\r\n");
				echo("FAILED. Contact the software vendor.<br>\r\n");
				$terminate=1;
			}
		}
		if($terminate != 1)
		{
			//Proceed with upgrade process
			//Extract ZIP archive
			echo ("Extracting MRS files into temporary directory...");
			$arch=new ZipArchive;
			if($arch->open("latest.zip"))
			{
				$debug=$arch->extractTo("temp");
				if($debug === true)
				{
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": extracted archive contents\r\n");
					echo ("DONE.<br>\r\n");
				}
				else
				{
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": failed to extract\r\n");
					echo("FAILED. Could not extract archive. Please re-download the MRS upgrade package, or contact the software vendor.<br>\r\n");
					$terminate=1;
				}
				$arch->close();
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": failed to open archive\r\n");
				echo("FAILED. Could not open archive. Please re-download the MRS upgrade package, or contact the software vendor.<br>\r\n");
				$terminate=1;
			}
		}
		if($terminate != 1)
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": replacing PHP files\r\n");
			//Process additional directives
			echo ("Enumerating pre-core-replace upgrade directives...");
			if(file_exists("temp/directives.txt"))
			{
				//Get contents of directives file and separate it by line
				$directives=explode("\r\n",file_get_contents("temp/directives.txt"));
				//Format each line (format: filename|destinationfolder/filename)
				for($i=0;$i<count($directives);$i++)
				{
					$directives[$i]=explode("|",$directives[$i]);
				}
			}
			else
			{
				$directives=array();
			}
			//Output number of directives to process
			echo ("DONE. There are " . count($directives) . " directives.<br>\r\n");
			if(count($directives) > 0)
			{
				//There are directives to process
				foreach($directives as $directive)
				{
					echo ("Processing directive: rename " . $directive[0] . " to " . $directive[1] . "...");
					$debug=rename("temp/" . $directive[0] . ".php","../" . $directive[1] . ".php");
					if($debug === true)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Proceed with upgrade process
			//Enumerate PHP files to replace
			echo ("Enumerating core files to replace...");
			$files=glob("temp/*.php");
			for($i=0;$i<count($files);$i++)
			{
				//Make sure upgrade PHP files do not get moved!
				if(strpos($files[$i],"upgrade-") !== false)
				{
					unset($files[$i]);
				}
			}
			echo ("DONE.<br>\r\n");
			//Replace PHP files
			if(count($files) > 0)
			{
				foreach($files as $file)
				{
					//Make name pretty for display
					$name=substr($file,5,-4);
					echo ("Replacing file \"$name\"...");
					$debug=rename($file,"../" . $name . ".php");
					if($debug === true)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Replace background
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": replacing background\r\n");
			echo ("Replacing background file...");
			$debug=rename("temp/background.gif","../backend/background.gif");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Replace background
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": replacing favicon\r\n");
			echo ("Replacing icon...");
			$debug=rename("temp/favicon.ico","../backend/favicon.ico");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Enumerate current config file base
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": getting list of existing config files\r\n");
			//List of files NOT to remove
			$retain=array("firstuse","password","postid","version","baselist","songlist","rules");
			echo ("Enumerating config files...");
			$files=glob("../backend/*.txt");
			$oldcfgs=array();
			foreach($files as $file)
			{
				$file=substr($file,11,-4);
				if(!in_array($file,$retain))
				{
					$oldcfgs[]=$file;
				}
			}
			echo ("DONE.<br>\r\n");
			//Enumerate new config file base
			echo ("Enumerating system base configuration...");
			if(file_exists("temp/config.txt"))
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": getting list of new config files\r\n");
				$configs=explode("\r\n",file_get_contents("temp/config.txt"));
				$newcfg=array();
				foreach($configs as $config)
				{
					$config=explode("|",$config);
					$newcfg[]=$config[0];
				}
				echo ("DONE.<br>\r\n");
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": failed to get list of new config files\r\n");
				echo ("FAILED. Proceeding anyways, expect problems.<br>\r\n");
				$configs=array();
				$newcfg=array();
			}
			//Enumerate differences
			echo ("Determining differences between existing and new configs...");
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": differencing config files\r\n");
			if(count($newcfg) > 0 && count($files) > 0)
			{
				$old=array_diff($oldcfgs,$newcfg);
			}
			else
			{
				$old=array();
			}
			echo ("DONE. " . count($old) . " obsolete files, " . count($newcfg) . " new/existing files. Existing files will be overwritten.<br>\r\n");
			//Remove obsolete configs
			if(count($old) > 0)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": removing obsolete config files\r\n");
				foreach($old as $config)
				{
					echo ("Removing obsolete config file \"$config\"...");
					$debug=unlink("../backend/" . $config . ".txt");
					if($debug === true)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Install new config files
			if(count($configs) > 0)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": installing new config files\r\n");
				foreach($configs as $config)
				{
					$config=explode("|",$config);
					echo ("Installing config file \"$config[0]\"...");
					$fh2=fopen("../backend/" . $config[0] . ".txt",'w');
					if($fh2)
					{
						fwrite($fh2,$config[1]);
						fclose($fh2);
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Bump version number
			echo ("Installing version information file...");
			$debug=rename("temp/version.txt","../backend/version.txt");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Overwrite upgrade scripts                
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": finishing upgrade\r\n");
			echo ("Finishing upgrade...");
			$debug=array(false,false,false);
			$debug[0]=rename("temp/upgrade-index.php","index.php");
			$debug[1]=rename("temp/upgrade-keep.php","keep.php");
			$debug[2]=rename("temp/upgrade-destroy.php","destroy.php");
			if((($debug[0] === $debug[1]) === $debug[2]) === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Clean up
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": removing temporary files\r\n");
			echo ("Removing upgrade templates...");
			$files=glob("temp/*");
			$error=0;
			if(count($files) > 0)
			{
				foreach($files as $file)
				{
					$debug=unlink($file);
					if($debug !== true)
					{
						$error++;
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": failed to remove file \"$file\"\r\n");
					}
				}
			}
			echo ("DONE. $error errors.<br>\r\n");
			//Remove temporary directory
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": removing temporary directory\r\n");
			echo ("Removing temporary directory...");
			$debug=rmdir("temp");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Remove ZIP file
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": removing zip file\r\n");
			echo ("Removing ZIP archive...");
			$debug=unlink("latest.zip");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Remove MD5 file
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": removing MD5 file\r\n");
			echo ("Removing MD5 hash...");
			if(file_exists("latest-md5.txt"))
			{
				$debug=unlink("latest-md5.txt");
				if($debug === true)
				{
					echo ("DONE.<br>\r\n");
				}
				else
				{
					echo ("FAILED.<br>\r\n");
				}
			}
			else
			{
				echo ("file does not exist, skipping.<br>\r\n");
			}
		}
        echo ("Upgrade process ended. Check output and/or logfiles for errors before leaving this page.<br>\r\n");
		fclose($fh);
	}
    else
    {
		//Only show page if user is an administrator
        if(securitycheck() === false)
		{
			die("You are not an administrator. <a href=\"../login.php\">Sign in</a> or <a href=\"../index.php\">Cancel</a>.");
		}
		//Download ZIP (if needed)
		if(!file_exists("latest.zip"))
		{
			echo ("Package required for updating not found, attempting to download...");
			//Open zip file
			$dfh=fopen("latest.zip",'w+');
			if($dfh)
			{
				//Initialize curl
				$curl=curl_init();
				$check=-1;
				if($curl !== false)
				{
					//Set curl options
					if(file_exists("../backend/stable.txt") && file_get_contents("../backend/stable.txt") == "yes")
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-stable.zip");
					}
					else
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest.zip");
					}
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_BINARYTRANSFER, true);
					curl_setopt($curl, CURLOPT_FILE,$dfh);
					curl_setopt($curl, CURLOPT_HEADER, false);
					//Execute curl
					curl_exec($curl);
					
					//Check and form the data
					if(!curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						//Curl failed
						echo ("FAILED, error code " . curl_errno($curl) . ", HTTP response code " . curl_getinfo($curl,CURLINFO_HTTP_CODE) . ". Contact the software vendor and threaten to microwave their microphone.<br>\r\n");
						$cfail=true;
					}
					//Close session
					curl_close($curl);
					fclose($dfh);
				}
			}
			else
			{
				//Cannot open the file for writing.
				echo ("FAILED, unable to save file. Submerge the upgrade directory in pool water.<br>\r\n");
			}
		}
		//Delete leftover traces if curl failed and file didn't exist beforehand
		if(isset($cfail) && $cfail === true)
		{
			unlink("latest.zip");
		}
		//Verify that the file does exist
		echo ("Double-checking to make sure the required package exists...");
		if(file_exists("latest.zip"))
		{
			//Exists
			echo ("DONE.<br>\r\n");
		}
		else
		{
			//Doesn't exist
			echo ("FAILED. Either you had ONE JOB and didn't name the file correctly (it should be \"latest.zip\"), or the server needs to be microwaved.<br>\r\n");
			$terminate=1;
		}
		//Proceed after error handling
		if($terminate != 1)
		{
			//Verify MD5 sums
			echo ("Calculating MD5 hash of local ZIP archive...");
			$md5local=md5_file("latest.zip");
			echo ("DONE. MD5 hash: " . $md5local . "<br>\r\n");
			//Download MD5 hash from home server
			echo ("Downloading MD5 hash comparison file...");
			$md5remote=false;
			if(!file_exists("latest-md5.txt"))
			{
				//Initialize curl
				$curl=curl_init();
				$check=-1;
				if($curl !== false)
				{
					//Set curl options
					if(file_exists("../backend/stable.txt") && file_get_contents("../backend/stable.txt") == "yes")
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-stable-md5.txt");
					}
					else
					{
						curl_setopt($curl, CURLOPT_URL, "http://firealarms.redbat.ca/mrs/latest-md5.txt");
					}
					curl_setopt($curl, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($curl, CURLOPT_HEADER, false);
					//Execute curl
					$data = curl_exec($curl);
					
					//Check and form the data
					if($data != "" && !curl_errno($curl) && curl_getinfo($curl,CURLINFO_HTTP_CODE) == 200)
					{
						$md5remote=$data;
						echo ("DONE. MD5 hash:" . $md5remote . "<br>\r\n");
					}
					else
					{
						//Curl failed
						echo ("FAILED.<br>\r\n");
					}
					//Close session
					curl_close($curl);
				}
			}
			else
			{
				//Local MD5 exists
				$md5remote=file_get_contents("latest-md5.txt");
			}
			//Make sure MD5s match
			echo ("Checking MD5 hashes...");
			if($md5remote !== false && $md5remote != "" && $md5local == $md5remote)
			{
				echo ("DONE. Checksums matched, proceeding with upgrade.<br>\r\n");
			}
			elseif($md5remote == "" || $md5remote === false)
			{
				echo ("SKIPPED. No MD5 to compare to. Proceeding with upgrade, expect problems.<br>\r\n");
			}
			else
			{
				echo("DONE. MD5s do NOT match, aborting upgrade process. Please re-download the MRS upgrade package, or contact the software vendor.<br>\r\n");
				$terminate=1;
			}
		}
		if($terminate != 1)
		{
			//Proceed with upgrade process
			//Create blank directory
			echo ("Creating temporary extraction directory...");
			$debug=mkdir("temp");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo("FAILED. Contact the software vendor.<br>\r\n");
				$terminate=1;
			}
		}
		if($terminate != 1)
		{
			//Proceed with upgrade process
			//Extract ZIP archive
			echo ("Extracting MRS files into temporary directory...");
			$arch=new ZipArchive;
			if($arch->open("latest.zip"))
			{
				$debug=$arch->extractTo("temp");
				if($debug === true)
				{
					echo ("DONE.<br>\r\n");
				}
				else
				{
					echo("FAILED. Could not extract archive. Please re-download the MRS upgrade package, or contact the software vendor.<br>\r\n");
					$terminate=1;
				}
				$arch->close();
			}
			else
			{
				echo("FAILED. Could not open archive. Please re-download the MRS upgrade package, or contact the software vendor.<br>\r\n");
				$terminate=1;
			}
		}
		if($terminate != 1)
		{
			//Process additional directives
			echo ("Enumerating pre-core-replace upgrade directives...");
			if(file_exists("temp/directives.txt"))
			{
				//Get contents of directives file and separate it by line
				$directives=explode("\r\n",file_get_contents("temp/directives.txt"));
				//Format each line (format: filename|destinationfolder/filename)
				for($i=0;$i<count($directives);$i++)
				{
					$directives[$i]=explode("|",$directives[$i]);
				}
			}
			else
			{
				$directives=array();
			}
			//Output number of directives to process
			echo ("DONE. There are " . count($directives) . " directives.<br>\r\n");
			if(count($directives) > 0)
			{
				//There are directives to process
				foreach($directives as $directive)
				{
					echo ("Processing directive: rename " . $directive[0] . " to " . $directive[1] . "...");
					$debug=rename("temp/" . $directive[0] . ".php","../" . $directive[1] . ".php");
					if($debug === true)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Proceed with upgrade process
			//Enumerate PHP files to replace
			echo ("Enumerating core files to replace...");
			$files=glob("temp/*.php");
			for($i=0;$i<count($files);$i++)
			{
				//Make sure upgrade PHP files do not get moved!
				if(strpos($files[$i],"upgrade-") !== false)
				{
					unset($files[$i]);
				}
			}
			echo ("DONE.<br>\r\n");
			//Replace PHP files
			if(count($files) > 0)
			{
				foreach($files as $file)
				{
					//Make name pretty for display
					$name=substr($file,5,-4);
					echo ("Replacing file \"$name\"...");
					$debug=rename($file,"../" . $name . ".php");
					if($debug === true)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Replace background
			echo ("Replacing background file...");
			$debug=rename("temp/background.gif","../backend/background.gif");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Replace favicon
			echo ("Replacing icon...");
			$debug=rename("temp/favicon.ico","../backend/favicon.ico");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Enumerate current config file base
			//List of files NOT to remove
			$retain=array("firstuse","password","postid","version","baselist","songlist","rules");
			echo ("Enumerating config files...");
			$files=glob("../backend/*.txt");
			$oldcfgs=array();
			foreach($files as $file)
			{
				$file=substr($file,11,-4);
				if(!in_array($file,$retain))
				{
					$oldcfgs[]=$file;
				}
			}
			echo ("DONE.<br>\r\n");
			//Enumerate new config file base
			echo ("Enumerating system base configuration...");
			if(file_exists("temp/config.txt"))
			{
				$configs=explode("\r\n",file_get_contents("temp/config.txt"));
				$newcfg=array();
				foreach($configs as $config)
				{
					$config=explode("|",$config);
					$newcfg[]=$config[0];
				}
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED. Proceeding anyways, expect problems.<br>\r\n");
				$configs=array();
				$newcfg=array();
			}
			//Enumerate differences
			echo ("Determining differences between existing and new configs...");
			if(count($newcfg) > 0 && count($files) > 0)
			{
				$old=array_diff($oldcfgs,$newcfg);
			}
			else
			{
				$old=array();
			}
			echo ("DONE. " . count($old) . " obsolete files, " . count($newcfg) . " new/existing files. Existing files will be overwritten.<br>\r\n");
			//Remove obsolete configs
			if(count($old) > 0)
			{
				foreach($old as $config)
				{
					echo ("Removing obsolete config file \"$config\"...");
					$debug=unlink("../backend/" . $config . ".txt");
					if($debug === true)
					{
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Install new config files
			if(count($configs) > 0)
			{
				foreach($configs as $config)
				{
					$config=explode("|",$config);
					echo ("Installing config file \"$config[0]\"...");
					$fh2=fopen("../backend/" . $config[0] . ".txt",'w');
					if($fh2)
					{
						fwrite($fh2,$config[1]);
						fclose($fh2);
						echo ("DONE.<br>\r\n");
					}
					else
					{
						echo ("FAILED.<br>\r\n");
					}
				}
			}
			//Bump version number
			echo ("Installing version information file...");
			$debug=rename("temp/version.txt","../backend/version.txt");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Overwrite upgrade scripts                
			echo ("Finishing upgrade...");
			$debug=array(false,false,false);
			$debug[0]=rename("temp/upgrade-index.php","index.php");
			$debug[1]=rename("temp/upgrade-keep.php","keep.php");
			$debug[2]=rename("temp/upgrade-destroy.php","destroy.php");
			if((($debug[0] === $debug[1]) === $debug[2]) === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Clean up
			echo ("Removing upgrade templates...");
			$files=glob("temp/*");
			$error=0;
			if(count($files) > 0)
			{
				foreach($files as $file)
				{
					$debug=unlink($file);
					if($debug !== true)
					{
						$error++;
					}
				}
			}
			echo ("DONE. $error errors.<br>\r\n");
			//Remove temporary directory
			echo ("Removing temporary directory...");
			$debug=rmdir("temp");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Remove ZIP file
			echo ("Removing ZIP archive...");
			$debug=unlink("latest.zip");
			if($debug === true)
			{
				echo ("DONE.<br>\r\n");
			}
			else
			{
				echo ("FAILED.<br>\r\n");
			}
			//Remove MD5 file
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": removing MD5 file\r\n");
			echo ("Removing MD5 hash...");
			if(file_exists("latest-md5.txt"))
			{
				$debug=unlink("latest-md5.txt");
				if($debug === true)
				{
					echo ("DONE.<br>\r\n");
				}
				else
				{
					echo ("FAILED.<br>\r\n");
				}
			}
			else
			{
				echo ("file does not exist, skipping.<br>\r\n");
			}
		}
        echo ("Upgrade process ended. Check output and/or logfiles for errors before leaving this page.<br>\r\n");
    }
  ?>
  <a href="../index.php">Go home</a></p>
  </body>
</html>