<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	//If password_verify and password_hash not defined, define them.
	if(!function_exists("password_verify"))
	{
		function password_verify($password,$hash)
		{
			$pass=hash("whirlpool",base64_encode(hash("whirlpool",base64_encode(hash("whirlpool",$password)))));
			if($pass == $hash)
			{
				return true;
			}
			return false;
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live show? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Change Password</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <?php
	 if(isset($_POST['s']) && $_POST['s'] == "y")
	 {
		$error=false;
		 //Start submission
		 if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			 $ip=$_SERVER['REMOTE_ADDR'];
			 $date=date("g:i:s");
			 $fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			 //Check password
			 if(password_verify($_POST['pass'],base64_decode(file_get_contents("backend/password.txt"))) === true)
			 {
				 //Password correct, get values
				 if(isset($_POST['level']) && $_POST['level'] != "")
				 {
					 $date=date("g:i:s");
					 fwrite($fh,$ip . " at " . $date . ": Changing security level\r\n");
					 //Sanitize first
					 $level=preg_replace("/[^0-9]/","",$_POST['level']);
					 //Make sure that $level is valid
					 if($level != "" && $level >= 0 && $level <= 7)
					 {
						 //Level is valid, write it to the appropriate file
						 $fh2=fopen("backend/security.txt",'w');
						 if($fh2)
						 {
							 //File opened, write data and close file
							 fwrite($fh2,$level);
							 fclose($fh2);
						 }
						 else
						 {
							 //Failed to open file
							 echo ("Failed to open file \"backend/security.txt\" in write mode. Microwave it and try again.<br>\r\n");
							 $error=true;
						 }
					 }
				 }
				 //FUTURE USE for timeout
				 if(isset($_POST['timeout']) && $_POST['timeout'] != "")
				 {
					 $date=date("g:i:s");
					 fwrite($fh,$ip . " at " . $date . ": Changing timeout time\r\n");
					 //Sanitize first
					 $timeout=preg_replace("/[^0-9]/","",$_POST['timeout']);
					 //Make sure that $level is valid
					 if($timeout != "" && $timeout >= 0 && $timeout <= 60)
					 {
						 //Level is valid, write it to the appropriate file
						 $fh2=fopen("backend/timeout.txt",'w');
						 if($fh2)
						 {
							 //File opened, write data and close file
							 fwrite($fh2,$timeout);
							 fclose($fh2);
						 }
						 else
						 {
							 //Failed to open file
							 echo ("Failed to open file \"backend/timeout.txt\" in write mode. Microwave it and try again.<br>\r\n");
							 $error=true;
						 }
					 }
				 }
				 //If no error occurred, destroy the existing session
				 if($error === false)
				 {
					 if(isset($_SESSION['sradmin']))
					 {
						 $_SESSION['sradmin']="n";
					 }
					 if(isset($_SESSION['identifier']))
					 {
						 $_SESSION['identifier']="";
					 }
					 $debug=session_destroy();
					 if($debug === true)
					 {
						 $date=date("g:i:s");
						 fwrite($fh,$ip . " at " . $date . ": Destroyed existing session\r\n");
					 }
					 else
					 {
						 $date=date("g:i:s");
						 fwrite($fh,$ip . " at " . $date . ": Failed to destroy existing session\r\n");
					 }
					 //Get out of here
					 echo ("<script type=\"text/javascript\">window.location = \"index.php?sc=yes\"</script>");
				}
			 }
			 else
			 {
				 $date=date("g:i:s");
				 fwrite($fh,$ip . " at " . $date . ": Supplied incorrect password\r\n");
				 echo ("Failed to change security level, password supplied was incorrect.<br>\r\n");
			 }
		 }
		 else
		 {
			 //Change the timezone
			 if(file_exists("backend/timezone.txt"))
			 {
				 date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			 }
			 else
			 {
			 	 date_default_timezone_set("America/Toronto");
			 }
			 //Check password
			 if(password_verify($_POST['pass'],base64_decode(file_get_contents("backend/password.txt"))) === true)
			 {
				 //Password correct, get values
				 if(isset($_POST['level']) && $_POST['level'] != "")
				 {
					 //Sanitize first
					 $level=preg_replace("/[^0-9]/","",$_POST['level']);
					 //Make sure that $level is valid
					 if($level != "" && $level >= 0 && $level <= 7)
					 {
						 //Level is valid, write it to the appropriate file
						 $fh2=fopen("backend/security.txt",'w');
						 if($fh2)
						 {
							 //File opened, write data and close file
							 fwrite($fh2,$level);
							 fclose($fh2);
						 }
						 else
						 {
							 //Failed to open file
							 echo ("Failed to open file \"backend/security.txt\" in write mode. Microwave it and try again.<br>\r\n");
							 $error=true;
						 }
					 }
				 }
				 //FUTURE USE for timeout
				 if(isset($_POST['timeout']) && $_POST['timeout'] != "")
				 {
					 //Sanitize first
					 $timeout=preg_replace("/[^0-9]/","",$_POST['timeout']);
					 //Make sure that $level is valid
					 if($timeout != "" && $timeout >= 0 && $timeout <= 60)
					 {
						 //Level is valid, write it to the appropriate file
						 $fh2=fopen("backend/timeout.txt",'w');
						 if($fh2)
						 {
							 //File opened, write data and close file
							 fwrite($fh2,$timeout);
							 fclose($fh2);
						 }
						 else
						 {
							 //Failed to open file
							 echo ("Failed to open file \"backend/timeout.txt\" in write mode. Microwave it and try again.<br>\r\n");
							 $error=true;
						 }
					 }
				 }
				 //If no error occurred, destroy the existing session
				 if($error === false)
				 {
					 if(isset($_SESSION['sradmin']))
					 {
						 $_SESSION['sradmin']="n";
					 }
					 if(isset($_SESSION['identifier']))
					 {
						 $_SESSION['identifier']="";
					 }
					 session_destroy();
					 //Get out of here
					 echo ("<script type=\"text/javascript\">window.location = \"index.php?sc=yes\"</script>");
				}
			 }
			 else
			 {
				 echo ("Failed to change security level, password supplied was incorrect.<br>\r\n");
			 }
		 }
	 }
	 else
	 {
		 if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			 $ip=$_SERVER['REMOTE_ADDR'];
			 $date=date("g:i:s");
			 $fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			 fwrite($fh,$ip . " at " . $date . ": Visited security change page page\r\n");
			 if(securitycheck() === false)
			 {
				 fclose($fh);
				 die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			 }
			 fclose($fh);
		 }
		 else
		 {
			 if(securitycheck() === false)
			 {
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			 }
		 }
	 }
?>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System-Change Security Level</h1>
  <p>There are seven different security levels. As part of its authentication mechanism, the MRS can store any combination of the following:</p>
  <ul>
  <li>The user's IP address</li>
  <li>The user agent string of the user's browser</li>
  <li>A unique "user identifier".</li>
  </ul>
  <p>in addition to a "switch" that tells the system you have logged in. In future releases, it may also feature "session timeout" functionality; for now, this is disabled.</p>
  <p>Below is a chart of the various security levels, and what they mean.</p>
  <table width="60%" border="1px solid #000000">
  <tr>
  <th>Level</th>
  <th>IP Address</th>
  <th>User Agent</th>
  <th>Identifier</th>
  </tr>
  <tr>
  <th>0</th>
  <th>No</th>
  <th>No</th>
  <th>No</th>
  </tr>
  <tr>
  <th>1</th>
  <th>Yes</th>
  <th>No</th>
  <th>No</th>
  </tr>
  <tr>
  <th>2</th>
  <th>No</th>
  <th>Yes</th>
  <th>No</th>
  </tr>
  <tr>
  <th>3</th>
  <th>Yes</th>
  <th>Yes</th>
  <th>No</th>
  </tr>
  <tr>
  <th>4</th>
  <th>No</th>
  <th>No</th>
  <th>Yes</th>
  </tr>
  <tr>
  <th>5</th>
  <th>Yes</th>
  <th>No</th>
  <th>Yes</th>
  </tr>
  <tr>
  <th>6</th>
  <th>No</th>
  <th>Yes</th>
  <th>Yes</th>
  </tr>
  <tr>
  <th>7</th>
  <th>Yes</th>
  <th>Yes</th>
  <th>Yes</th>
  </tr>
  </table>
  <form method="post" action="security.php">
  <input type="hidden" name="s" value="y">
  Security level: <select name="level">
  <option value="">Select one</option>
  <option value="0">0</option>
  <option value="1">1</option>
  <option value="2">2</option>
  <option value="3">3</option>
  <option value="4">4</option>
  <option value="5">5</option>
  <option value="6">6</option>
  <option value="7">7</option>
  </select><br>
  Timeout: <select name="timeout" disabled="disabled">
  <option value="">Select one</option>
  <option value="5">5</option>
  <option value="10">10</option>
  <option value="20">20</option>
  <option value="25">25</option>
  <option value="30">30</option>
  <option value="45">45</option>
  <option value="60">60</option>
  <option value="0">Indefinite</option>
  </select> minutes<br>
  Re-enter password: <input type="password" name="pass" required="required"><br>
  <input type="submit" value="Change"> or <input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>