<?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		$ip=$_SERVER['REMOTE_ADDR'];
		$date=date("g:i:s");
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		fwrite($fh,$ip . " at " . $date . ": Visited rules page\r\n");
		fclose($fh);
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="dcterms.created" content="Thu, 31 Jul 2014 03:23:24 GMT">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title>Request Rules</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
    <!--[if IE]>
    <script src="http://html5shim.googlecode.com/svn/trunk/html5.js"></script>
    <![endif]-->
  </head>
  <body>
  <h1 style="text-align:center;">Request Rules</h1>
  <hr>
  <p>The general rule for requests can be found <a href="http://greyghost.mooo.com/live-stream-rules.html">here</a>, however this request system has a few of it's own. This page will also serve to re-iterate a few rules as well.</p>
  <ul>
  <?php
	//Get contents of rule file and split it into lines
    if(file_exists("backend/rules.txt"))
    {
        $rules=explode("\r\n",file_get_contents("backend/rules.txt"));
    }
    else
    {
        $rules=array("There are no specific rules set in the system at present.");
    }
	//Output rules as list items
	foreach($rules as $rule)
	{
		echo "<li>" . stripcslashes($rule) . "</li>\r\n";
	}
  ?>
  </ul>
  <p>As a helpful tip, when making open requests, please list the album and/or the year if you can. I have multiple versions of many songs, and it would help me find the correct version faster.</p>
  <hr>
  <p><a href="index.php">Go back</a></p>
  </body>
</html>