<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Report Request</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <?php
	//Function for determining if user is banned
	function is_banned()
	{
        if(file_exists("ban/ip.txt"))
        {
            $iplist=file_get_contents("ban/ip.txt");
        }
        else
        {
            $iplist="";
        }
		$ip=$_SERVER['REMOTE_ADDR'];
		if(strpos($iplist,$ip) === false)
		{
			return false;
		}
		return true;
	}
	
  	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
			//Make sure the system has mailing enabled
			if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") == "yes")
			{
				//Get the email address to send the request to
				if(file_exists("backend/email.txt") && file_get_contents("backend/email.txt") != "")
				{
					//Safe to proceed
					$email=base64_decode(file_get_contents("backend/email.txt"));
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Obtained email address to send report to\r\n");
					//Make sure IP addresses are valid
					if(!filter_var($_POST['uip'],FILTER_VALIDATE_IP))
					{
						echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=3\"</script>");
					}
					//Sanitization work
					$id=preg_replace("/[^0-9]/", "", $_POST['id']);
					$username=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['name']);
					$pdate=preg_replace("/[^0-9/]/", "", $_POST['date']);
					$request=filter_var($_POST['request'],FILTER_SANITIZE_STRING);
					$rdate=preg_replace("/[^0-9/]/", "", $_POST['rdate']);
					$comment=filter_var($_POST['comment'],FILTER_SANITIZE_STRING);
					//Write email string
					$string="Post #" . $id . ", written by \"" . $name . "\ on " . $pdate . " was reported by a user with IP address " . $_POST['uip'] . " on " . $rdate . ".\r\n";
					$string.="Request content: " . $request . "\r\n";
					//NOTE: trim whitespace before sanitizing!
					$string.="Report comment: " . $comment;
					//Send email
					$debug=mail($email,"Reported request on MRS",$string,"From: lowendradiorequests@gmail.com");
					if($debug === true)
					{
						//Success
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Successfully sent email for report " . $_POST['id'] . "\r\n");
					}
					else
					{
						//Failure
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Failed to email for report " . $_POST['id'] . "\r\n");
					}
					fclose($fh);
					//Get out of here
					echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=0\"</script>");
				}
				else
				{
					//Unsafe to proceed
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": No email address found, stopping\r\n");
					fclose($fh);
					echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=1\"</script>");
				}
			}
			else
			{
				//No mailing supported
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Emails disabled\r\n");
				fclose($fh);
				echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=2\"</script>");
			}
		}
		elseif(is_banned() === false)
		{
			//Sanitize post number!
			$post=preg_replace("/[^0-9]/", "", $_GET['p']);
			//Get file info
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited report page for post \"" . $post . "\"\r\n");
			if(file_exists("posts/" . $post . ".txt"))
			{
				//Post exists
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Obtained details for post \"" . $post . "\"\r\n");
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
			}
			else
			{
				//Post does not exist
				fwrite($fh,$ip . " at " . $date . ": Encountered error obtaining details for post \"" . $post . "\"\r\n");
				fclose($fh);
				echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=5\"</script>");
			}
			fclose($fh);
		}
		else
		{
			//User is banned
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited report page for post \"" . $_GET['p'] . "\"\r\n");
			fclose($fh);
			echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=4\"</script>");
		}
	}
	else
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging disabled
		if(isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
			//Make sure the system has mailing enabled
			if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") == "yes")
			{
				//Get the email address to send the request to
				if(file_exists("backend/email.txt") && file_get_contents("backend/email.txt") != "")
				{
					//Safe to proceed
					$email=base64_decode(file_get_contents("backend/email.txt"));
					//Make sure IP addresses are valid
					if(!filter_var($_POST['uip'],FILTER_VALIDATE_IP))
					{
						echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=3\"</script>");
					}
					//Sanitization work
					$id=preg_replace("/[^0-9]/", "", $_POST['id']);
					$username=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['name']);
					$pdate=preg_replace("/[^0-9/]/", "", $_POST['date']);
					$request=filter_var($_POST['request'],FILTER_SANITIZE_STRING);
					$rdate=preg_replace("/[^0-9/]/", "", $_POST['rdate']);
					$comment=filter_var($_POST['comment'],FILTER_SANITIZE_STRING);
					//Write email string
					$string="Post #" . $id . ", written by \"" . $name . "\ on " . $pdate . " was reported by a user with IP address " . $_POST['uip'] . " on " . $rdate . ".\r\n";
					$string.="Request content: " . $request . "\r\n";
					//NOTE: trim whitespace before sanitizing!
					$string.="Report comment: " . $comment;
					//Send email
					mail($email,"Reported request on MRS",$string,"From: lowendradiorequests@gmail.com");
					//Get out of here
					echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=0\"</script>");
				}
				else
				{
					//Unsafe to proceed
					echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=1\"</script>");
				}
			}
			else
			{
				//No mailing supported
				echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=2\"</script>");
			}
		}
		elseif(is_banned() === false)
		{
			//Sanitize post number!
			$post=preg_replace("/[^0-9]/", "", $_GET['p']);
			//Get file info
			if(file_exists("posts/" . $post . ".txt"))
			{
				//Post exists
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
			}
			else
			{
				//Post does not exist
				echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=5\"</script>");
			}
		}
		else
		{
			//User is banned
			echo ("<script type=\"text/javascript\">window.location = \"index.php?repstatus=4\"</script>");
		}
	}
	//Make sure the system has mailing enabled
	if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") != "yes")
	{
		//Mailing disabled
		$disabled=true;
	}
  ?>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System-Report Post #<?php echo $contents[0]; ?></h1>
  <?php
	if($disabled === true)
	{
		echo ("<p>The system administrator has disabled system emails, so reporting does not work.</p>");
	}
  ?>
  <form method="post" action="report.php">
  <input type="hidden" name="confirm" value="y">
  <input type="hidden" name="id" value="<?php echo $contents[0]; ?>">
  <input type="hidden" name="name" value="<?php echo $contents[1]; ?>">
  <input type="hidden" name="ip" value="<?php echo $contents[2]; ?>">
  <input type="hidden" name="date" value="<?php echo $contents[3]; ?>">
  <input type="hidden" name="uip" value="<?php echo $_SERVER['REMOTE_ADDR']; ?>">
  <input type="hidden" name="rdate" value="<?php echo date("m/d/Y g:i A"); ?>">
  Request to report: <input type="text" name="request" value="<?php echo $contents[4]; ?>" readonly="readonly"><br>
  Comments:<br>
  <textarea name="comment" required="required" rows="10" cols="50"></textarea><br>
  <input type="submit" value="Confirm" <?php if($disabled === true) { echo "disabled=\"disabled\""; } ?>> or <input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>