<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
	//Function for getting post contents
	function get_post_contents($post)
	{
		//Read file, decode it, then split it based on the new line character to get the contents
		return(explode("\r\n",base64_decode(file_get_contents($post))));
	}
    //Function for getting all open requests
    function get_open_reqs()
    {
        //Initialize
        $reqs=0;
        //Get all posts
        $files=glob("posts/*.txt");
        if(count($files) > 0)
        {
            //Loop through posts
            foreach($files as $file)
            {
                //Get contents
                $contents=get_post_contents($file);
                //Get only the status number
                $contents=explode("|",$contents[5]);
                $contents=$contents[0];
                //If number is not 1 (declined) or 3 (played), increment count
                if($contents == 0 || $contents == 2)
                {
                    $reqs++;
                }
            }
        }
        return $reqs;
    }
	function check_if_already_requested($requeststring)
	{
		//Get all posts
		$files=glob("posts/*.txt");
		//Loop through all posts (if any exist)
		if(count($files) > 0)
		{
			foreach($files as $file)
			{
				//Get post contents
				$contents=get_post_contents($file);
				//Check if request is the same as the one being made
				if($contents[5] == $requeststring)
				{
					//Yes it is
					return true;
				}
			}
		}
		//Request does not exist
		return false;
	}
	//Function for determining system overload point
	function system_overload()
	{
		if(!file_exists("backend/limit.txt") || file_get_contents("backend/limit.txt") == "" || intval(file_get_contents("backend/limit.txt")) == 0)
		{
			//No system overload limit set
			return 0;
		}
		return intval(file_get_contents("backend/limit.txt"));
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled on system
		$ip=$_SERVER['REMOTE_ADDR'];
		$date=date("g:i:s");
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		fwrite($fh,$ip . " at " . $date . ": Visited posting page\r\n");
		fclose($fh);
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Make A Request</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>MRS-Make A Request</h1>
  <?php
	//Function for checking if the user has a pending request
	function pendingrequest($username)
	{
		if(!isset($username) || $username == "")
		{
			return false;
		}
		$files=glob("posts/*.txt");
		foreach($files as $file)
		{
			$contents=explode("\r\n",base64_decode(file_get_contents($file)));
			if($contents[1] == $username)
			{
				$status=explode("|",$contents[5]);
				if($status[0] != 3 && $status[0] != 1)
				{
					return true;
				}
			}
		}
		return false;
	}
    
	//Function for counting user's requests
	function countrequest($uni,$username,$modifier)
	{
		if(!isset($username) || $username == "")
		{
			return 0;
		}
		$files=glob("posts/*.txt");
		$count=0;
		foreach($files as $file)
		{
			$contents=explode("\r\n",base64_decode(file_get_contents($file)));
			//True for username, false for IP address
			if($uni === true)
			{
				$un=$contents[1];
			}
			else
			{
				$un=$contents[2];
			}
			if($un == $username && time() < (strtotime($contents[3]) + $modifier))
			{
				$count++;
			}
		}
		return $count;
	}
	
	//Function for checking for "ballot box stuffing"
	function box_stuffer($requeststring)
	{
		//Get all posts
		$posts=glob("posts/*.txt");
		//Loop through all posts
		foreach($posts as $post)
		{
			//Decode the contents and split it
			$contents=explode("\r\n",base64_decode(file_get_contents($post)));
			//Check to make sure the request isn't already in the system
			if($contents[4] == $requeststring)
			{
				return true;
			}
		}
		//Request is not in the system
		return false;
	}
	
	//Function for checking for overages
	function lockout()
	{
		if(file_exists("backend/type.txt"))
		{
			$modifier=file_get_contents("backend/type.txt");
		}
		else
		{
			$modifier=1;
		}
		switch($modifier)
		{
			case 0:
			$modifier=(1*60*60);
			break;
			case 1:
			$modifier=(3*60*60);
			break;
			case 2:
			$modifier=(24*60*60);
			break;
			default:
			$modifier=(1*60*60);
			break;
		}
	
		//FORMAT: username,IP,day restriction
		$lockout=array(2,5,10);
	
		if(file_exists("backend/iplock.txt"))
		{
			$lockout[1]=file_get_contents("backend/iplock.txt");
		}
		if(file_exists("backend/unlock.txt"))
		{
			$lockout[0]=file_get_contents("backend/unlock.txt");
		}
		if(file_exists("backend/dayrestrict.txt"))
		{
			$lockout[2]=file_get_contents("backend/dayrestrict.txt");
		}
	
		if($lockout[0] != 0 && countrequest(true,$_SESSION['uname'],$modifier) >= $lockout[0])
		{
			return false;
		}
	
		if($lockout[1] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],$modifier) >= $lockout[1])
		{
			return false;
		}
	
		if($lockout[2] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],$modifier) >= $lockout[2])
		{
			return false;
		}
        
		return true;
	}
	
	//Change the timezone
	if(file_exists("backend/timezone.txt"))
	{
		date_default_timezone_set(file_get_contents("backend/timezone.txt"));
	}
	else
	{
		date_default_timezone_set("America/Toronto");
	}
	
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(isset($_POST['submit']) && $_POST['submit'] == "y")
		{
			//Submission started
			/* Methodology:
			-Check if posting is enabled
			-Check if anonymous
			-Make sure user can post request
			-Filter username and request
			-Make sure request is not in system
			-Check for request overages
			-Write the file
			-Send email message
			-Write to XML file */
			
			if(file_exists("backend/posting.txt") && file_get_contents("backend/posting.txt") != "yes")
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": system closed\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=1\"</script>");
			}
            if(system_overload() > 0 && get_open_reqs() > system_overload())
            {
                $date=date("g:i:s");
                fwrite($fh,$ip . " at " . $date . ": system is in overflow mode\r\n");
                fclose($fh);
                die("<script type=\"text/javascript\">window.location = \"index.php?status=6\"</script>");
            }
			
			if($_POST['anon'] != "y" && (!isset($_POST['name']) || $_POST['name'] == ""))
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Had empty name and not anonymous\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=3\"</script>");
			}
			elseif($_POST['anon'] == "y")
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Started submission as anonymous\r\n");
				$name="Anonymous";
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Started submission as " . $_POST['name'] . "\r\n");
				$name=$_POST['name'];
			}
			
			$name=preg_replace("/[^A-Za-z0-9 ]/", "", $name);
			$_SESSION['uname']=$name;
			
			if(file_exists("ban/uname.txt"))
			{
				$uban=file_get_contents("ban/uname.txt");
			}
			else
			{
				$uban="";
			}
			if(file_exists("ban/ip.txt"))
			{
				$iban=file_get_contents("ban/ip.txt");
			}
			else
			{
				$iban="";
			}
			if(strpos($uban,$name) !== false || strpos($iban,$_SERVER['REMOTE_ADDR']) !== false)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": banned from system\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=2\"</script>");
			}
			
			if($_POST['request'] != "" && isset($_POST['request']))
			{
				$request=htmlspecialchars($_POST['request']);
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Had empty request\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=3\"</script>");
			}
			
			if(box_stuffer($request) === true)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": attempt to stuff the box detected\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=5\"</script>");
			}
			
			if(lockout() !== true)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": attempt to post excessive requests detected\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=4\"</script>");
			}
			
			if(file_exists("backend/postid.txt"))
			{
				$pid=file_get_contents("backend/postid.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Obtained current post ID\r\n");
			}
			else
			{
				$pid=-1;
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Made first post\r\n");
			}
			$pid++;
			$fh2=fopen("backend/postid.txt",'w') or die("Failed to open file \"backend/postid.txt\" in write mode. It should now be microwaved..");
			fwrite($fh2,$pid);
			fclose($fh2);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Set post ID\r\n");
			
			$date2=date("m/d/Y g:i A");
			$post=$pid . "\r\n" . stripcslashes($name) . "\r\n" . $_SERVER['REMOTE_ADDR'] . "\r\n" . $date2 . "\r\n" . stripcslashes($request) . "\r\n" . "0|None\r\n";
			$fh2=fopen("posts/" . $pid . ".txt",'w') or die("Failed to open file \"posts/" . $pid . ".txt\" in write mode. It or the containing folder should now be microwaved..");
			fwrite($fh2,base64_encode($post));
			fclose($fh2);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Wrote post " . $pid . "\r\n");
			
			//Check if system emailing support is turned on
			if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") == "yes")
			{
				//Create email text
				$emailtext="Request made by " . stripcslashes($name) . " at " . $date2 . "\r\n" . stripcslashes($request) . "\r\nGo to the Music Request System to put this in the queue or to decline it.";
				//Get the email address to send the request to
				if(file_exists("backend/email.txt") && file_get_contents("backend/email.txt") != "")
				{
					//Safe to proceed with email
					$email=base64_decode(file_get_contents("backend/email.txt"));
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Obtained email address to send report to\r\n");
					//Send email
					$debug=mail($email,"Request made on MRS",$emailtext,"From: lowendradiorequests@gmail.com");
					if($debug === true)
					{
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Successfully sent email for request " . $pid . "\r\n");
					}
					else
					{
						$date=date("g:i:s");
						fwrite($fh,$ip . " at " . $date . ": Failed to email for request " . $pid . "\r\n");
					}
				}
				else
				{
					//Unsafe to proceed
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": No email address to send to, skipping\r\n");
				}
			}
			else
			{
				//Sendmail disabled
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Mailing disabled in system, skipping\r\n");
			}
			
			//NOTE: NONE of this is potentially valid for another request system, ONLY for the LER one! However, the RSS feed also isn't really useful for other systems either, as it is solely intended to interface with software that is only designed to interface with the LER MRS.
			$xml="<!-- insert here -->\n<entry>\n<author>" . stripcslashes($name) . "</author>\n<id>" . $pid . "</id>\n<link href=\"http://firealarms.redbat.ca/streamreq\"/>\n<title type=\"html\">Request # " . $pid . " at " . $date2 . "</title>\n<content type=\"text\">" . stripcslashes($request) . " made by " . stripcslashes($name) . "</content>\n</entry>";
			$xmlc=file_get_contents("rss/requests.xml");
			$xmlc=str_replace("<!-- insert here -->",$xml,$xmlc);
			$fh2=fopen("rss/requests.xml",'w') or die("Failed to open XML file \"rss/requests.xml\". It or the containing folder should now be microwaved.");
			fwrite($fh2,$xmlc);
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Updated request RSS feed\r\n");
			fclose($fh2);
			
			fclose($fh);
			echo ("<script type=\"text/javascript\">window.location = \"index.php?status=0\"</script>");
		}
		else
		{
			//Trying to make request
			if(file_exists("backend/posting.txt"))
			{
				$posting=file_get_contents("backend/posting.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Obtained details regarding posting\r\n");
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Failed to obtain details regarding posting, assuming closed.\r\n");
				$posting="no";
			}
            if(system_overload() > 0 && get_open_reqs() > system_overload())
            {
                $date=date("g:i:s");
                fwrite($fh,$ip . " at " . $date . ": system is in overflow mode\r\n");
                $posting="no";
            }
			if($posting == "yes")
			{
				$posting=true;
			}
			else
			{
				$posting=false;
			}
		
			if(file_exists("backend/pdreq.txt") && file_get_contents("backend/pdreq.txt") == "yes" && pendingrequest($_SESSION['uname']) === true)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Hit a lockout\r\n");
				$posting=false;
			}
			
            if($posting !== false)
            {
                $date=date("g:i:s");
                fwrite($fh,$ip . " at " . $date . ": Determining additional post lockout details\r\n");
                $posting=lockout();
            }
			
			if(file_exists("backend/anon.txt"))
			{
				$anon=file_get_contents("backend/anon.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-anonymous request (from system)\r\n");
			}
			else
			{
				$anon="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-anonymous request (default)\r\n");
			}
			if(file_exists("backend/open.txt"))
			{
				$open=file_get_contents("backend/open.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-open request (from system)\r\n");
			}
			else
			{
				$open="yes";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-open request (default)\r\n");
			}
		}
		fclose($fh);
	}
	else
	{
		//Logging Disabled
		if(isset($_POST['submit']) && $_POST['submit'] == "y")
		{
			//Submission started
			/* Methodology:
			-Check if posting is enabled
			-Check if anonymous
			-Make sure user can post request
			-Filter username and request
			-Make sure request is not in system
			-Check for request overages
			-Write the file
			-Send email message
			-Write to XML file */
			
			if(file_exists("backend/posting.txt") && file_get_contents("backend/posting.txt") != "yes")
			{
				die("<script type=\"text/javascript\">window.location = \"index.php?status=1\"</script>");
			}
            if(system_overload() > 0 && get_open_reqs() > system_overload())
            {
                die("<script type=\"text/javascript\">window.location = \"index.php?status=6\"</script>");
            }
			
			if($_POST['anon'] != "y" && (!isset($_POST['name']) || $_POST['name'] == ""))
			{
				die("<script type=\"text/javascript\">window.location = \"index.php?status=3\"</script>");
			}
			elseif($_POST['anon'] == "y")
			{
				$name="Anonymous";
			}
			else
			{
				$name=$_POST['name'];
			}
			
			$name=preg_replace("/[^A-Za-z0-9 ]/", "", $name);
			$_SESSION['uname']=$name;
			
			if(file_exists("ban/uname.txt"))
			{
				$uban=file_get_contents("ban/uname.txt");
			}
			else
			{
				$uban="";
			}
			if(file_exists("ban/ip.txt"))
			{
				$iban=file_get_contents("ban/ip.txt");
			}
			else
			{
				$iban="";
			}
			if(strpos($uban,$name) !== false || strpos($iban,$_SERVER['REMOTE_ADDR']) !== false)
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": banned from system\r\n");
				fclose($fh);
				die("<script type=\"text/javascript\">window.location = \"index.php?status=2\"</script>");
			}
			
			if($_POST['request'] != "" && isset($_POST['request']))
			{
				$request=htmlspecialchars($_POST['request']);
			}
			else
			{
				die("<script type=\"text/javascript\">window.location = \"index.php?status=3\"</script>");
			}
			
			if(box_stuffer($request) === true)
			{
				die("<script type=\"text/javascript\">window.location = \"index.php?status=5\"</script>");
			}
			
			if(lockout() !== true)
			{
				die("<script type=\"text/javascript\">window.location = \"index.php?status=4\"</script>");
			}
			
			if(file_exists("backend/postid.txt"))
			{
				$pid=file_get_contents("backend/postid.txt");
			}
			else
			{
				$pid=-1;
			}
			$pid++;
			$fh2=fopen("backend/postid.txt",'w') or die("Failed to open file \"backend/postid.txt\" in write mode. It should now be microwaved..");
			fwrite($fh2,$pid);
			fclose($fh2);
			
			$date2=date("m/d/Y g:i A");
			$post=$pid . "\r\n" . stripcslashes($name) . "\r\n" . $_SERVER['REMOTE_ADDR'] . "\r\n" . $date2 . "\r\n" . stripcslashes($request) . "\r\n" . "0|None\r\n";
			$fh2=fopen("posts/" . $pid . ".txt",'w') or die("Failed to open file \"posts/" . $pid . ".txt\" in write mode. It should now be microwaved..");
			fwrite($fh2,base64_encode($post));
			fclose($fh2);
			
			//Check if system emailing support is turned on
			if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") == "yes")
			{
				//Create email text
				$emailtext="Request made by " . stripcslashes($name) . " at " . $date2 . "\r\n" . stripcslashes($request) . "\r\nGo to the Music Request System to put this in the queue or to decline it.";
				//Get the email address to send the request to
				if(file_exists("backend/email.txt") && file_get_contents("backend/email.txt") != "")
				{
					//Safe to proceed with email
					$email=base64_decode(file_get_contents("backend/email.txt"));
					//Send email
					mail($email,"Request made on MRS",$emailtext,"From: lowendradiorequests@gmail.com");
				}
			}
			
			//See comment regarding RSS feed above
			$xml="<!-- insert here -->\n<entry>\n<author>" . stripcslashes($name) . "</author>\n<id>" . $pid . "</id>\n<link href=\"http://firealarms.redbat.ca/streamreq\"/>\n<title type=\"html\">Request # " . $pid . " at " . $date2 . "</title>\n<content type=\"text\">" . stripcslashes($request) . " made by " . stripcslashes($name) . "</content>\n</entry>";
			$xmlc=file_get_contents("rss/requests.xml");
			$xmlc=str_replace("<!-- insert here -->",$xml,$xmlc);
			$fh2=fopen("rss/requests.xml",'w') or die("Failed to open XML file \"rss/requests.xml\". It or the containing folder should now be microwaved.");
			fwrite($fh2,$xmlc);
			fclose($fh2);
			
			echo ("<script type=\"text/javascript\">window.location = \"index.php?status=0\"</script>");
		}
		else
		{
			//Trying to make request
			if(file_exists("backend/posting.txt"))
			{
				$posting=file_get_contents("backend/posting.txt");
			}
			else
			{
				$posting="no";
			}
            if(system_overload() > 0 && get_open_reqs() > system_overload())
            {
                $posting="no";
            }
			if($posting == "yes")
			{
				$posting=true;
			}
			else
			{
				$posting=false;
			}
		
			if(file_exists("backend/pdreq.txt") && file_get_contents("backend/pdreq.txt") == "yes" && pendingrequest($_SESSION['uname']) === true)
			{
				$posting=false;
			}
		
			if($posting !== false)
            {
                $posting=lockout();
            }
			
			if(file_exists("backend/anon.txt"))
			{
				$anon=file_get_contents("backend/anon.txt");
			}
			else
			{
				$anon="no";
			}
			if(file_exists("backend/open.txt"))
			{
				$open=file_get_contents("backend/open.txt");
			}
			else
			{
				$open="yes";
			}
		}
	}
  ?>
  <?php
	//Sanitize request, if necessary
	if(isset($_GET['req']) && $_GET['req'] != "")
	{
		$req=preg_replace("/[^A-Za-z0-9 ]/","",$_GET['req']);
	}
	else
	{
		$req="";
	}
  ?>
  <form action="post2.php" method="post">
  Request: <input type="text" size="50" name="request" required="required" <?php if($open != "yes") {echo ("readonly=\"readonly\"");} ?> value="<?php echo stripcslashes($req); ?>"><br>
  <input type="hidden" name="submit" value="y">
  <input type="hidden" name="posting" value="<?php if($posting === true) { echo "yes"; } else { echo "no"; } ?>">
  Name: <input type="text" name="name" value="<?php echo $_SESSION['uname']; ?>"> OR <input type="checkbox" name="anon" value="y" <?php if($anon == "no") { echo("disabled=\"disabled\""); } ?>>Anonymous<br>
  <input type="submit" id="sbutton" value="Make request" <?php if($posting === false) { echo "disabled=\"disabled\""; } ?>><input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>