<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//If "light" mode is enabled, bypass this page entirely
	if(file_exists("backend/light.txt") && file_get_contents("backend/light.txt") == "yes")
	{
		echo ("<script type=\"text/javascript\">window.location = \"post2.php\"</script>");
	}
?>
<?php
	//Open session
	session_start();
	//Function for getting post contents
	function get_post_contents($post)
	{
		//Read file, decode it, then split it based on the new line character to get the contents
		return(explode("\r\n",base64_decode(file_get_contents($post))));
	}
    //Function for getting all open requests
    function get_open_reqs()
    {
        //Initialize
        $reqs=0;
        //Get all posts
        $files=glob("posts/*.txt");
        if(count($files) > 0)
        {
            //Loop through posts
            foreach($files as $file)
            {
                //Get contents
                $contents=get_post_contents($file);
                //Get only the status number
                $contents=explode("|",$contents[5]);
                $contents=$contents[0];
                //If number is not 1 (declined) or 3 (played), increment count
                if($contents == 0 || $contents == 2)
                {
                    $reqs++;
                }
            }
        }
        return $reqs;
    }
	//Function for determining system overload point
	function system_overload()
	{
		if(!file_exists("backend/limit.txt") || file_get_contents("backend/limit.txt") == "" || intval(file_get_contents("backend/limit.txt")) == 0)
		{
			//No system overload limit set
			return 0;
		}
		return intval(file_get_contents("backend/limit.txt"));
	}
	//Function for checking if user has a pending request and if this is disallowed
	function has_pending_request()
	{
		if(file_exists("backend/pdreq.txt") && file_get_contents("backend/pdreq.txt") == "yes")
		{
			//System does not allow multiple requests of this type, continue
			if(pendingrequest() === true)
			{
				//User has a pending request, return true
				return true;
			}
		}
		//No criteria met, return false
		return false;
	}
	//Function for getting system lockouts
	function user_lockout()
	{
		if(file_exists("backend/type.txt"))
		{
			$modifier=file_get_contents("backend/type.txt");
		}
		else
		{
			$modifier=1;
		}
		switch($modifier)
		{
			case 0:
			$modifier=(1*60*60);
			break;
			case 1:
			$modifier=(3*60*60);
			break;
			case 2:
			$modifier=(24*60*60);
			break;
			default:
			$modifier=(1*60*60);
			break;
		}
		
		//FORMAT: username,IP,day restriction
		$lockout=array(2,5,10);
		
		if(file_exists("backend/iplock.txt"))
		{
			$lockout[1]=file_get_contents("backend/iplock.txt");
		}
		if(file_exists("backend/unlock.txt"))
		{
			$lockout[0]=file_get_contents("backend/unlock.txt");
		}
		if(file_exists("backend/dayrestrict.txt"))
		{
			$lockout[2]=file_get_contents("backend/dayrestrict.txt");
		}
		
		if($lockout[0] != 0 && countrequest(true,$_SESSION['uname'],$modifier) >= $lockout[0])
		{
			return true;
		}
		
		if($lockout[1] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],$modifier) >= $lockout[1])
		{
			return true;
		}
		
		if($lockout[2] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],(24*60*60)) >= $lockout[2])
		{
			return true;
		}
		
		return false;
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	function eh($errno, $errstr, $errfile, $errline)
	{
		switch ($errno)
		{
		case E_USER_WARNING:
		echo "<b><u>WARNING:</u></b> " . $errstr . "<br><br>\n";
        break;

		case E_USER_NOTICE:
        echo "<b><u>NOTICE:</u></b> " . $errstr . "<br><br>\n";
        break;
		
		case E_WARNING:
		echo "<b><u>PHP WARNING:</u></b> " . $errstr . "<br><br>\n";
        break;

		case E_NOTICE:
        break;

		default:
        echo "Unhandled error.<br><br>\n";
        break;
    	}

    	/* Don't execute PHP internal error handler */
    	return true;
	}
	function ehdebug($errno, $errstr, $errfile, $errline)
	{
		echo "<b><u>ERROR OCCURED:</u></b> Error number=" . $errno . "<br><br>\n";

    	/* Don't execute PHP internal error handler */
    	return true;
	}
?>
<?php
	//Function for getting Christmas music
	function christmas()
	{
		//Check if file exists (IE it's freaking December, dammit)
		if(file_exists("backend/christmas.txt"))
		{
			//Get contents of file and split it by line
			$music=explode("\r\n",file_get_contents("backend/christmas.txt"));
			//Split each song up into parts
			for($i=0;$i<count($music);$i++)
			{
				$music[$i]=explode("|",$music[$i]);
			}
			//Return songlist
			return $music;
		}
		else
		{
			//It isn't December yet!
			return false;
		}
	}
	//Function for getting music list
	function getmusic()
	{
		//Get contents of song list and split it into songs
		$music=explode("\r\n",file_get_contents("backend/songlist.txt"));
		//Return songlist
		return $music;
	}
	//Function for getting base music
	function getbase()
	{
		//Check if a base list exists, and that it is new enough to constitute "new"
		if(!file_exists("backend/baselist.txt") || time() > filemtime("backend/baselist.txt")+(7*24*60*60))
		{
			//Just return the song list
			return getmusic();
		}
		//Get and split and return the base list
		$music=explode("\r\n",file_get_contents("backend/baselist.txt"));
		return $music;
	}
	
	//Function for obtaining a list of songs, sorted based on new songs vs old songs
	function getsongs()
	{
		//Get base and song lists
		$bl=array_filter(getbase());
		$sl=array_filter(getmusic());
		//Select only those songs which are "new" (IE are in the song list but not the base list)
		$usl=array_diff($sl,$bl);
		//Return an array containing the unique "new" songs and the base list
		return array($usl,$bl);
	}
	
	//Function for obtaining output based on display options
	function dispquery($query)
	{
		if($query == "christmas" && christmas() === false)
		{
			//It is not Christmas!
			return array("CF","Christmas music gets played during December, dammit!");
		}
		elseif($query == "christmas")
		{
			//It is Christmas; return the list of Christmas songs
			return christmas();
		}
		elseif($query == "all")
		{
			//Return a list of all the music
			return getsongs();
		}
		else
		{
			//Get all the music
			$music=getsongs();
			//Set up array of matches
			$matches=array(array(),array());
			//Loop through all the new music
			for($i=0;$i<count($music[0]);$i++)
			{
				//Set up the song
				$item=explode("|",$music[0][$i]);
				if($query == "mod" && strtolower($item[2]) == "mod")
				{
					//User wishes to display all MOD music, and this is a MOD
					$matches[0][]=$music[0][$i];
				}
				elseif($query == "misc" && preg_match('/^\s*[a-zA-Z]/', strtolower($item[0])) == 0)
				{
					//User wishes to display all songs whose artist name does not begin with a letter
					$matches[0][]=$music[0][$i];
				}
				elseif(substr(strtolower($item[0]),0,1) == strtolower($query) && strtolower($item[2]) != "mod")
				{
					//Song matches queried letter and is not a MOD file
					$matches[0][]=$music[0][$i];
				}
			}
			//Loop is identical to the one above, except now it loops over the old music
			for($i=0;$i<count($music[1]);$i++)
			{
				$item=explode("|",$music[1][$i]);
				if($query == "mod" && strtolower($item[2]) == "mod")
				{
					$matches[1][]=$music[1][$i];
				}
				elseif($query == "misc" && preg_match('/^\s*[a-zA-Z]/', strtolower($item[0])) == 0)
				{
					$matches[1][]=$music[1][$i];
				}
				elseif(substr(strtolower($item[0]),0,1) == strtolower($query) && strtolower($item[2]) != "mod")
				{
					$matches[1][]=$music[1][$i];
				}
			}
			//Return the list of matches
			return $matches;
		}
	}
	//Function for searching a single song for a query
	function find($song,$query)
	{
		//Loop through all the parts of the song
		foreach($song as $sp)
		{
			//Convert the text to lowercase
			$hs=strtolower($sp);
			//Strip all non alphanumeric characters
			$hs=preg_replace('/[^A-Za-z0-9\-]/', '', $hs);
			
			if($hs != "" && strpos($hs,$query) !== false)
			{
				//Song matches query
				return true;
			}
		}
		//Song does not match query
		return false;
	}
	//Function for obtaining the words to strip
	function stripwords()
	{
		//Make sure list of words exists
		if(file_exists("backend/stripwords.txt") && file_get_contents("backend/stripwords.txt") != "")
		{
			//Get list of words, and split it into an array
			$stripwords=explode(", ",file_get_contents("backend/stripwords.txt"));
			//Format each word
			for($i=0;$i<count($stripwords);$i++)
			{
				$stripwords[$i]=" " . strtolower($stripwords[$i]) . " ";	
			}
			//Return list of words
			return $stripwords;
		}
		//No words, return blank array
		return array();
	}
	//Function for searching
	function search($query)
	{
		//Get all the music
		$music=getsongs();
		//Set up the list of matches
		$matches=array(array(),array());
		//Make query lowercase, and add leading and trailing whitespace (for word removal purposes)
		$query=" " . strtolower($query) . " ";
		//Get words to strip
		$stripwords=stripwords();
		//If there are words to strip, strip these words
		if(count($stripwords) > 0)
		{
			$query=str_replace($stripwords," ",$query);
		}
		//Remove all non alphanumeric characters from the query
		$query=preg_replace('/[^A-Za-z0-9\-]/', '', $query);
		//Make sure query is not empty
		if($query == "")
		{
			die("<script type=\"text/javascript\">window.location = \"post.php?blank=yes\"</script>");
		}
		//Loop through all the new music
		foreach($music[0] as $song)
		{
			//Convert to lowercase, and add leading and trailing whitespace (for word stripping purposes)
			$item=" " . strtolower($song) . " ";
			//If there are words to strip, strip these words
			if(count($stripwords) > 0)
			{
				$item=str_replace($stripwords," ",$item);
			}
			//Set up the song
			$item=explode("|",$item);
			if(find($item,$query) !== false && ((strtolower($item[2]) != "mod" && !isset($_GET['sm'])) || (strtolower($item[2]) == "mod" && isset($_GET['sm']))))
			{
				//Song matches the query, and either it is not a MOD or the user wishes to display MOD results
				$matches[0][]=$song;
			}
		}
		//Loop through all the old music
		foreach($music[1] as $song)
		{
			//Convert to lowercase, and add leading and trailing whitespace (for word stripping purposes)
			$item=" " . strtolower($song) . " ";
			//If there are words to strip, strip these words
			if(count($stripwords) > 0)
			{
				$item=str_replace($stripwords," ",$item);
			}
			//Set up the song
			$item=explode("|",$item);
			if(find($item,$query) !== false && ((strtolower($item[2]) != "mod" && !isset($_GET['sm'])) || (strtolower($item[2]) == "mod" && isset($_GET['sm']))))
			{
				//Song matches the query, and either it is not a MOD or the user wishes to display MOD results
				$matches[1][]=$song;
			}
		}
		//Return the list of songs
		return $matches;
	}
	//Function for checking if the song has been requested already
	function currentrequest($song)
	{
		//Get list of all requests
		$files=glob("posts/*.txt");
		foreach($files as $file)
		{
			//Decode and split the file
			$contents=explode("\r\n",base64_decode(file_get_contents($file)));
			if($contents[4] == $song)
			{
				//Song has been requested already
				return true;
			}
		}
		//Song has not been requested already
		return false;
	}
	//Function for checking if the user has a pending request
	function pendingrequest()
	{
		//Get user's IP address
		$username=$_SERVER['REMOTE_ADDR'];
		
		//Get list of all requests
		$files=glob("posts/*.txt");
		foreach($files as $file)
		{
			//Decode and splut the file
			$contents=get_post_contents($file);
			if($contents[2] == $username)
			{
				//Check the status of the request
				$status=explode("|",$contents[5]);
				if($status[0] == 0 || $status[0] == 2)
				{
					//User has a currently active request in the system
					return true;
				}
			}
		}
		//User does not have a currently active request in the system
		return false;
	}
	
	//Function for checking the count of songs the user has requested already.
	function countrequest($uni,$username,$modifier)
	{
		if(!isset($username) || $username == "")
		{
			//There is no username by which to count requests against
			return 0;
		}
		//Get list of all requests
		$files=glob("posts/*.txt");
		//Set up the counter
		$count=0;
		foreach($files as $file)
		{
			//Get contents of request
			$contents=explode("\r\n",base64_decode(file_get_contents($file)));
			//True for username, false for IP address
			if($uni === true)
			{
				//Get username from contents
				$un=$contents[1];
			}
			else
			{
				//Get IP address from contents
				$un=$contents[2];
			}
			if($un == $username && time() < (strtotime($contents[3]) + $modifier))
			{
				//User has made a request before the expiry time
				$count++;
			}
		}
		//Return the counter
		return $count;
	}
	//Function for displaying query results
	function displaysongs($open,$music)
	{
		sort($music[0]);
		sort($music[1]);
		
		foreach($music[0] as $item)
		{
			$item=explode("|",$item);
			if(count($item) == 4)
			{
				if($open === true && currentrequest($item[0] . "-" . $item[1] . " (from the album " . $item[2] . ", " . $item[3] . ")") === false)
				{
					echo "<img src=\"backend/new.gif\" alt=\"New\"><a href=\"post2.php?req=" . $item[0] . "-" . $item[1] . " (from the album " . $item[2] . ", " . $item[3] . ")\">Request this</a>: " . $item[0] . "-" . $item[1] . " (from the album \"" . $item[2] . "\", " . $item[3] . ")<br>\r\n";
				}
				else
				{
					echo "<img src=\"backend/new.gif\" alt=\"New\"><strike>Request this</strike>: " . $item[0] . "-" . $item[1] . " (from the album \"" . $item[2] . "\", " . $item[3] . ")<br>\r\n";
				}
			}
		}
		
		foreach($music[1] as $item)
		{
			$item=explode("|",$item);
			if($open === true && currentrequest($item[0] . "-" . $item[1] . " (from the album " . $item[2] . ", " . $item[3] . ")") === false)
			{
				echo "<a href=\"post2.php?req=" . $item[0] . "-" . $item[1] . " (from the album " . $item[2] . ", " . $item[3] . ")\">Request this</a>: " . $item[0] . "-" . $item[1] . " (from the album \"" . $item[2] . "\", " . $item[3] . ")<br>\r\n";
			}
			else
			{
				echo "<strike>Request this</strike>: " . $item[0] . "-" . $item[1] . " (from the album \"" . $item[2] . "\", " . $item[3] . ")<br>\r\n";
			}
		}
	}
	function is_open_enabled()
	{
		/* Check methodology
		-System is open or not
		-Open requests are enabled
		-No overload in system
		-No pending request for user
		-User has not exceeded request limit
		*/
		if(!file_exists("backend/posting.txt") || (file_exists("backend/posting.txt") && file_get_contents("backend/posting.txt") != "yes"))
		{
			//echo ("DEBUG: posting disabled.<br>\r\n");
			//System disabled
			return false;
		}
		if(!file_exists("backend/open.txt") || (file_exists("backend/open.txt") && file_get_contents("backend/open.txt") != "yes"))
		{
			//echo ("DEBUG: open disabled.<br>\r\n");
			//Open requests disabled
			return false;
		}
		if(system_overload() > 0 && get_open_reqs() > system_overload())
		{
			//echo ("DEBUG: system overloaded.<br>\r\n");
			//System in overload mode
			return false;
		}
		if(has_pending_request() !== false)
		{
			//echo ("DEBUG: pending request.<br>\r\n");
			//Pending request in system
			return false;
		}
		if(user_lockout() === true)
		{
			//echo ("DEBUG: user lockout.<br>\r\n");
			//User has hit lockout
			return false;
		}
		//Everything passed
		return true;
	}
?>
<?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled on system
		$ip=$_SERVER['REMOTE_ADDR'];
		$date=date("g:i:s");
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		fwrite($fh,$ip . " at " . $date . ": Visited posting page\r\n");
		fclose($fh);
	}
	//Check if the user is banned
	if(isset($_SESSION['uname']))
	{
		$uname=$_SESSION['uname'];
	}
	else
	{
		$uname="";
	}
	$ip=$_SERVER['REMOTE_ADDR'];
	$ulist=file_get_contents("ban/uname.txt");
	$iplist=file_get_contents("ban/ip.txt");
	if((isset($uname) && $uname != "" && strpos($ulist,$uname) !== false) || strpos($iplist,$ip) !== false)
	{
		//User is banned, redirect them back to the main page
		echo ("<script type=\"text/javascript\">window.location = \"index.php\"</script>");
		die();
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Make A Request</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>MRS-Make A Request</h1>
  <form action="post.php" method="get">
  <input type="hidden" name="type" value="search">
  <?php
	//Make sure that searching is allowed
	if(file_exists("backend/searching.txt") && file_get_contents("backend/searching.txt") == "yes")
	{
		$search=true;
	}
	else
	{
		$search=false;
	}
  ?>
  Search for a song: <input type="text" name="query" <?php if($search !== true) { echo ("value=\"Searching disabled\" disabled=\"disabled\""); } elseif(isset($_GET['query'])) { echo("value=\"" . $_GET['query'] . "\"");} ?>> Show me MOD file results: <input type="checkbox" name="sm" <?php if($search !== true) { echo ("disabled=\"disabled\""); } ?>><input type="submit" value="Search" <?php if($search !== true) { echo ("disabled=\"disabled\""); } elseif(isset($_POST['sm'])) { echo ("checked=\"checked\""); } ?>><br>
  </form>
  Or, display songs: <a href="post.php?type=display&query=all">ALL</a> | <a href="post.php?type=display&query=a">A</a> | <a href="post.php?type=display&query=b">B</a> | <a href="post.php?type=display&query=c">C</a> | <a href="post.php?type=display&query=d">D</a> | <a href="post.php?type=display&query=e">E</a> | <a href="post.php?type=display&query=f">F</a> | <a href="post.php?type=display&query=g">G</a> | <a href="post.php?type=display&query=h">H</a> | <a href="post.php?type=display&query=i">I</a> | <a href="post.php?type=display&query=j">J</a> | <a href="post.php?type=display&query=k">K</a> | <a href="post.php?type=display&query=l">L</a> | <a href="post.php?type=display&query=m">M</a> | <a href="post.php?type=display&query=n">N</a> | <a href="post.php?type=display&query=o">O</a> | <a href="post.php?type=display&query=p">P</a> | <a href="post.php?type=display&query=q">Q</a> | <a href="post.php?type=display&query=r">R</a> | <a href="post.php?type=display&query=s">S</a> | <a href="post.php?type=display&query=t">T</a> | <a href="post.php?type=display&query=u">U</a> | <a href="post.php?type=display&query=v">V</a> | <a href="post.php?type=display&query=w">W</a> | <a href="post.php?type=display&query=x">X</a> | <a href="post.php?type=display&query=y">Y</a> | <a href="post.php?type=display&query=z">Z</a> | <a href="post.php?type=display&query=misc">Other</a> | <a href="post.php?type=display&query=mod">MOD</a> | <a href="post.php?type=display&query=christmas">Christmas Music</a><br>
  Or, <?php
		//Make sure that open requests are enabled, that submitting requests is enabled, and that the user does not have a pending request (when having such is not permitted)
		//if(file_exists("backend/open.txt") && file_get_contents("backend/open.txt") == "yes" && file_exists("backend/posting.txt") && file_get_contents("backend/posting.txt") == "yes" && (file_exists("backend/limit.txt") && file_get_contents("backend/limit.txt") > 0 && get_open_reqs() <= file_get_contents("backend/limit.txt")) && ((pendingrequest() === true && file_exists("backend/pdreq.txt") && file_get_contents("backend/pdreq.txt") == "yes")))
		//if(file_exists("backend/open.txt") && file_get_contents("backend/open.txt") == "yes" && file_exists("backend/posting.txt") && file_get_contents("backend/posting.txt") == "yes" && system_overload() === false && has_pending_request() === false)
		if(is_open_enabled() === true)
		{
			echo ("<a href=\"post2.php\">make a request not on this list</a>");
		}
		else
		{
			echo ("<strike>make a request not on this list</strike>");
		}
  ?><br>
  <hr>
  <?php
	$oeh=set_error_handler("eh");
	//$oeh=set_error_handler("ehdebug");
	//error_reporting(E_ALL);
		/* Path to follow:
		-Get posting status
		-Get number of requests made by user+if they have active request
		-Perform query
		-Display results */
		$posting="no";
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(isset($_GET['blank']))
		{
			//User submitted blank query, or a query that eventually became blank
			trigger_error("The query you submitted was blank, or contained no usable search terms. Please try again.");
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Submitted blank request\r\n");
		}
		if(file_exists("backend/posting.txt"))
		{
			$posting=file_get_contents("backend/posting.txt");
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained details regarding posting\r\n");
		}
		else
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Failed to obtain details regarding posting, assuming closed.\r\n");
			$posting="no";
		}
        if(system_overload() > 0 && get_open_reqs() > system_overload())
        {
			trigger_error("The system is presently experiencing an overflow in requests. Please try again later.",E_USER_WARNING);
			$posting="no";
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": System is in overflow mode\r\n");
        }
		if($posting == "yes")
		{
			$posting=true;
		}
		else
		{
			$posting=false;
		}
		
		if(file_exists("backend/pdreq.txt"))
		{
			switch(file_get_contents("backend/pdreq.txt"))
			{
				case "yes":
				$pdreq=true;
				break;
				default:
				$pdreq=false;
				break;
			}
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained details regarding request restriction\r\n");
		}
		else
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Failed to obtain details regarding request restriction, assuming closed.\r\n");
			$pdreq=false;
		}
		
		if(pendingrequest() === true && $pdreq === true)
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Hit a lockout\r\n");
			trigger_error("You have a presently unplayed/undeclined request. Please wait until this request is played or declined.",E_USER_NOTICE);
			$posting=false;
		}
		
		/*if(file_exists("backend/type.txt"))
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained post lockout information\r\n");
			$modifier=file_get_contents("backend/type.txt");
		}
		else
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Failed to obtain details regarding lockout, assuming 3 hours.\r\n");
			$modifier=1;
		}
		switch($modifier)
		{
			case 0:
			$modifier=(1*60*60);
			break;
			case 1:
			$modifier=(3*60*60);
			break;
			case 2:
			$modifier=(24*60*60);
			break;
			default:
			$modifier=(1*60*60);
			break;
		}
		
		//FORMAT: username,IP,day restriction
		$date=date("g:i:s");
		fwrite($fh,$ip . " at " . $date . ": Setting assumed post lockout information\r\n");
		$lockout=array(2,5,10);
		
		if(file_exists("backend/iplock.txt"))
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained IP lockout information\r\n");
			$lockout[1]=file_get_contents("backend/iplock.txt");
		}
		if(file_exists("backend/unlock.txt"))
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained username lockout information\r\n");
			$lockout[0]=file_get_contents("backend/unlock.txt");
		}
		if(file_exists("backend/dayrestrict.txt"))
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained daily lockout information\r\n");
			$lockout[2]=file_get_contents("backend/dayrestrict.txt");
		}
		
		if($lockout[0] != 0 && countrequest(true,$_SESSION['uname'],$modifier) >= $lockout[0])
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Hit a lockout\r\n");
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}
		
		if($lockout[1] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],$modifier) >= $lockout[1])
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Hit a lockout\r\n");
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}
		
		if($lockout[2] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],(24*60*60)) >= $lockout[2])
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Hit a lockout\r\n");
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}*/
		
		if(user_lockout() === true)
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Hit a lockout\r\n");
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}
		
		if(isset($_GET['query']) && $_GET['query'] != "" && isset($_GET['type']) && $_GET['type'] != "")
		{
			if($_GET['type'] == "search")
			{
				displaysongs($posting,search($_GET['query']));
			}
			else
			{
				$music=dispquery($_GET['query']);
				if($music[0] == "CF")
				{
					echo ("Christmas music gets played during December, DAMMIT!<br>");
				}
				else
				{
					displaysongs($posting,$music);
				}
			}
		}
	}
	else
	{
		//Logging disabled
		if(isset($_GET['blank']))
		{
			//User submitted blank query, or a query that eventually became blank
			trigger_error("The query you submitted was blank, or contained no usable search terms. Please try again.");
		}
		if(file_exists("backend/posting.txt"))
		{
			$posting=file_get_contents("backend/posting.txt");
		}
		else
		{
			$posting="no";
		}
		//echo ("DEBUG: system_overload()=" . system_overload() . ", get_open_reqs()=" . get_open_reqs() . "<br>\r\n");
        if(system_overload() > 0 && get_open_reqs() > system_overload())
        {
			trigger_error("The system is presently experiencing an overflow in requests. Please try again later.",E_USER_WARNING);
			$posting="no";
        }
		if($posting == "yes")
		{
			$posting=true;
		}
		else
		{
			$posting=false;
		}
		
		if(file_exists("backend/pdreq.txt"))
		{
			switch(file_get_contents("backend/pdreq.txt"))
			{
				case "yes":
				$pdreq=true;
				break;
				default:
				$pdreq=false;
				break;
			}
		}
		else
		{
			$pdreq=false;
		}
		
		if(pendingrequest() === true && $pdreq === true)
		{
			trigger_error("You have a presently unplayed/undeclined request. Please wait until this request is played or declined.",E_USER_NOTICE);
			$posting=false;
		}
		
		/*if(file_exists("backend/type.txt"))
		{
			$modifier=file_get_contents("backend/type.txt");
		}
		else
		{
			$modifier=1;
		}
		switch($modifier)
		{
			case 0:
			$modifier=(1*60*60);
			break;
			case 1:
			$modifier=(3*60*60);
			break;
			case 2:
			$modifier=(24*60*60);
			break;
			default:
			$modifier=(1*60*60);
			break;
		}
		
		//FORMAT: username,IP,day restriction
		$lockout=array(2,5,10);
		
		if(file_exists("backend/iplock.txt"))
		{
			$lockout[1]=file_get_contents("backend/iplock.txt");
		}
		if(file_exists("backend/unlock.txt"))
		{
			$lockout[0]=file_get_contents("backend/unlock.txt");
		}
		if(file_exists("backend/dayrestrict.txt"))
		{
			$lockout[2]=file_get_contents("backend/dayrestrict.txt");
		}
		
		if($lockout[0] != 0 && countrequest(true,$_SESSION['uname'],$modifier) >= $lockout[0])
		{
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}
		
		if($lockout[1] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],$modifier) >= $lockout[1])
		{
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}
		
		if($lockout[2] != 0 && countrequest(false,$_SERVER['REMOTE_ADDR'],$modifier) >= $lockout[2])
		{
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}*/
		
		if(user_lockout() === true)
		{
			trigger_error("User has exceeded the request limit",E_USER_WARNING);
			$posting=false;
		}
		
		if(isset($_GET['query']) && $_GET['query'] != "" && isset($_GET['type']) && $_GET['type'] != "")
		{
			if($_GET['type'] == "search")
			{
				displaysongs($posting,search($_GET['query']));
			}
			else
			{
				$music=dispquery($_GET['query']);
				if($music[0] == "CF")
				{
					echo ("Christmas music gets played during December, DAMMIT!<br>");
				}
				else
				{
					displaysongs($posting,$music);
				}
			}
		}
	}
?>
  <br><a href="index.php">Cancel</a>
  </body>
</html>