<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Mark Request As Played</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <?php
  	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(securitycheck() === true && isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
			//Sanitize the post number!
			$post=preg_replace("/[^0-9]/","",$_POST['p']);
			//Make sure file exists
			if(file_exists("posts/" . $post . ".txt"))
			{
				//Update file
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
				//Split status contents
				$contents[5]=explode("|",$contents[5]);
				//Modify request status
				$contents[5][0]=3;
				//Unsplit status contents
				$contents[5]=implode("|",$contents[5]);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Modified info for post \"" . $post . "\"\r\n");
				$contents[1]=stripcslashes($contents[1]);
				$contents[4]=stripcslashes(htmlspecialchars($contents[4]));
				$contents[5]=stripcslashes($contents[5]);
				$contents=base64_encode(implode("\r\n",$contents));
				$fh2=fopen("posts/" . $post . ".txt",'w') or die("Failed to open file \"posts/" . $post . ".txt\" in write mode. It should now be microwaved.");
				fwrite($fh2,$contents);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Updated post \"" . $post . "\"\r\n");
				fclose($fh);
				fclose($fh2);
				echo ("<script type=\"text/javascript\">window.location = \"index.php?mapstatus=0\"</script>");
			}
			else
			{
				echo ("<script type=\"text/javascript\">window.location = \"index.php?mapstatus=1\"</script>");
			}
		}
		elseif(securitycheck() === true)
		{
			//Sanitize the post number!
			$post=preg_replace("/[^0-9]/","",$_GET['p']);
			//Get file info
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited mark as played page for post \"" . $post . "\"\r\n");
			if(file_exists("posts/" . $post . ".txt"))
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Obtained details for post \"" . $post . "\"\r\n");
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
			}
			else
			{
				fwrite($fh,$ip . " at " . $date . ": Encountered error obtaining details for post \"" . $post . "\"\r\n");
				fclose($fh);
				die("Failed to obtain request information for post #" . $post . ". Microwave the request file.");
			}
			fclose($fh);
		}
		else
		{
			//Sanitize the post number!
			$post=preg_replace("/[^0-9]/","",$_GET['p']);
			//Nope.
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited mark as played page for post \"" . $post . "\"\r\n");
			fclose($fh);
			die("You are not authorized to mark this post as played. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
		}
	}
	else
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		if(securitycheck() === true && isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
			//Sanitize the post number!
			$post=preg_replace("/[^0-9]/","",$_POST['p']);
			//Make sure file exists
			if(file_exists("posts/" . $post . ".txt"))
			{
				//Update file
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
				//Split status contents
				$contents[5]=explode("|",$contents[5]);
				//Modify request status
				$contents[5][0]=3;
				//Unsplit status contents
				$contents[5]=implode("|",$contents[5]);
				$contents[1]=stripcslashes($contents[1]);
				$contents[4]=stripcslashes(htmlspecialchars($contents[4]));
				$contents[5]=stripcslashes($contents[5]);
				$contents=base64_encode(implode("\r\n",$contents));
				$fh2=fopen("posts/" . $post . ".txt",'w') or die("Failed to open file \"posts/" . $post . ".txt\" in write mode. It should now be microwaved.");
				fwrite($fh2,$contents);
				fclose($fh2);
				echo ("<script type=\"text/javascript\">window.location = \"index.php?mapstatus=0\"</script>");
			}
			else
			{
				echo ("<script type=\"text/javascript\">window.location = \"index.php?mapstatus=1\"</script>");
			}
		}
		elseif(securitycheck() === true)
		{
			//Sanitize the post number!
			$post=preg_replace("/[^0-9]/","",$_GET['p']);
			//Get file info
			if(file_exists("posts/" . $post . ".txt"))
			{
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
			}
			else
			{
				die("Failed to obtain request information for post #" . $post . ". Microwave the request file.");
			}
		}
		else
		{
			//Sanitize the post number!
			$post=preg_replace("/[^0-9]/","",$_GET['p']);
			//Nope.
			die("You are not authorized to decline this post. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
		}
	}
  ?>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System-Mark Request In Post #<?php echo $post; ?> As Played</h1>
  <p>Post info:</p>
  <pre><?php var_dump($contents); ?></pre>
  <form method="post" action="played.php">
  <input type="hidden" name="confirm" value="y">
  <input type="hidden" name="p" value="<?php echo $post; ?>">
  <input type="submit" value="Confirm"> or <input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>