<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	//If password_verify and password_hash not defined, define them.
	if(!function_exists("password_hash"))
	{
		//NOTE: The original password hash function has an "options" parameter this doesn't. For the purposes of this, it isn't necessary, but be careful!
		//Also note that algorithm has a default value; we won't use this either
		function password_hash($password,$algorithm="whirlpool")
		{
			//Make sure algorithm is appropriate
			$algorithm="whirlpool";
			return hash($algorithm,base64_encode(hash($algorithm,base64_encode(hash($algorithm,$password)))));
		}
	}
	
	if(!function_exists("password_verify"))
	{
		function password_verify($password,$hash)
		{
			$pass=hash("whirlpool",base64_encode(hash("whirlpool",base64_encode(hash("whirlpool",$password)))));
			if($pass == $hash)
			{
				return true;
			}
			return false;
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live show? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Change Password</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <?php
	 if(isset($_POST['s']) && $_POST['s'] == "y")
	 {
		 //Start submission
		 if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			 $ip=$_SERVER['REMOTE_ADDR'];
			 $date=date("g:i:s");
			 $fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			 //Make sure password file exists
			 if(file_exists("backend/password.txt"))
			 {
				 //Safe to proceed, verify the existing password and that the new passwords match
				 if(password_verify($_POST['old'],base64_decode(file_get_contents("backend/password.txt"))) === true && $_POST['new'] == $_POST['confirm'])
				 {
					//Everything is good, hash the password, write it, and get out of here
					$hash=base64_encode(password_hash($_POST['new'],PASSWORD_DEFAULT));
					$fh2=fopen("backend/password.txt",'w') or die("Failed to open file \"backend/password.txt\" in write mode. It should now be microwaved.");
					fwrite($fh2,$hash);
					fclose($fh2);
					//Destroy the "first use" flag file if it exists (no one cares if this fails, it'll just result in the system always saying the password needs to be changed)
					if(file_exists("backend/firstuse.txt"))
					{
						unlink("backend/firstuse.txt");
					}
					fwrite($fh,$ip . " at " . $date . ": Changed password successfully\r\n");
					fclose($fh);
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=0\"</script>");
				 }
				 elseif(password_verify($_POST['old'],base64_decode(file_get_contents("backend/password.txt"))) !== true)
				 {
					//Old password given is not correct
					fwrite($fh,$ip . " at " . $date . ": Failed to change password; old password incorrect\r\n");
					fclose($fh);
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=1\"</script>");
				 }
				 elseif($_POST['new'] != $_POST['confirm'])
				 {
					//Old password given is not correct
					fwrite($fh,$ip . " at " . $date . ": Failed to change password; new passwords did not match\r\n");
					fclose($fh);
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=2\"</script>");
				 }
				 else
				 {
					//Some other problem happened, assume the file couldn't be opened
					fwrite($fh,$ip . " at " . $date . ": Failed to change the password\r\n");
					fclose($fh);
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=3\"</script>");
				 }
			 }
			 else
			 {
				 //Unsafe to proceed
				fwrite($fh,$ip . " at " . $date . ": Failed to change the password\r\n");
				fclose($fh);
				echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=3\"</script>");
			 }
		 }
		 else
		 {
			 //Change the timezone
			 if(file_exists("backend/timezone.txt"))
			 {
				 date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			 }
			 else
			 {
			 	 date_default_timezone_set("America/Toronto");
			 }
			 //Make sure password file exists
			 if(file_exists("backend/password.txt"))
			 {
				 //Safe to proceed, verify the existing password and that the new passwords match
				 if(password_verify($_POST['old'],base64_decode(file_get_contents("backend/password.txt"))) === true && $_POST['new'] == $_POST['confirm'])
				 {
					//Everything is good, hash the password, write it, and get out of here
					$hash=base64_encode(password_hash($_POST['new'],PASSWORD_DEFAULT));
					$fh2=fopen("backend/password.txt",'w') or die("Failed to open file \"backend/password.txt\" in write mode. It should now be microwaved.");
					fwrite($fh2,$hash);
					fclose($fh2);
					//Destroy the "first use" flag file if it exists (no one cares if this fails, it'll just result in the system always saying the password needs to be changed)
					if(file_exists("backend/firstuse.txt"))
					{
						unlink("backend/firstuse.txt");
					}
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=0\"</script>");
				 }
				 elseif(password_verify($_POST['old'],base64_decode(file_get_contents("backend/password.txt"))) !== true)
				 {
					//Old password given is not correct
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=1\"</script>");
				 }
				 elseif($_POST['new'] != $_POST['confirm'])
				 {
					//Old password given is not correct
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=2\"</script>");
				 }
				 else
				 {
					//Some other problem happened, assume the file couldn't be opened
					echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=3\"</script>");
				 }
			 }
			 else
			 {
				 //Unsafe to proceed
				echo ("<script type=\"text/javascript\">window.location = \"admin.php?pchange=3\"</script>");
			 }
		 }
	 }
	 else
	 {
		 if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			 $ip=$_SERVER['REMOTE_ADDR'];
			 $date=date("g:i:s");
			 $fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			 fwrite($fh,$ip . " at " . $date . ": Visited password change page page\r\n");
			 if(securitycheck() === false)
			 {
				 fclose($fh);
				 die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			 }
			 fclose($fh);
		 }
		 else
		 {
			 if(securitycheck() === false)
			 {
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			 }
		 }
	 }
?>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System-Change System Password</h1>
  <form method="post" action="password.php">
  <input type="hidden" name="s" value="y">
  Current password: <input type="password" name="old" required="required"><br>
  New password: <input type="password" name="new" required="required"><br>
  Confirm: <input type="password" name="confirm" required="required"><br>
  <input type="submit" value="Change"> or <input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>