<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	//If password_verify not defined, define it
	if(!function_exists("password_verify"))
	{
		function password_verify($password,$hash)
		{
			$pass=hash("whirlpool",base64_encode(hash("whirlpool",base64_encode(hash("whirlpool",$password)))));
			if($pass == $hash)
			{
				return true;
			}
			return false;
		}
	}
	//Function for setting session
	function login()
	{
		//Set session cookie
		$_SESSION['sradmin']="y";
		//Check for security level
		if(file_exists("backend/security.txt") && file_get_contents("backend/security.txt") != "")
		{
			switch(intval(file_get_contents("backend/security.txt")))
			{
				case 1:
				//IP only
				$_SESSION['ip']=$_SERVER['REMOTE_ADDR'];
				break;
				case 2:
				//Useragent only
				$_SESSION['ua']=$_SERVER['HTTP_USER_AGENT'];
				break;
				case 3:
				//IP and useragent
				$_SESSION['ip']=$_SERVER['REMOTE_ADDR'];
				$_SESSION['ua']=$_SERVER['HTTP_USER_AGENT'];
				break;
				case 4:
				//Unique identifier only
				$_SESSION['identifier']=mt_rand(0,2000000);
				break;
				case 5:
				//Unique identifier and IP
				$_SESSION['ip']=$_SERVER['REMOTE_ADDR'];
				$_SESSION['identifier']=mt_rand(0,2000000);
				break;
				case 6:
				//Unique identifer and useragent
				$_SESSION['ua']=$_SERVER['HTTP_USER_AGENT'];
				$_SESSION['identifier']=mt_rand(0,2000000);
				break;
				case 7:
				//All the things
				$_SESSION['ip']=$_SERVER['REMOTE_ADDR'];
				$_SESSION['ua']=$_SERVER['HTTP_USER_AGENT'];
				$_SESSION['identifier']=mt_rand(0,2000000);
				break;
			}
		}
	}
	//Custom error handler
	function eh($errno, $errstr, $errfile, $errline)
	{
		switch ($errno)
		{
			case E_USER_WARNING:
			echo "<b><u>WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_USER_NOTICE:
			echo "<b><u>NOTICE:</u></b> " . $errstr . "<br><br>\n";
			break;
			
			case E_WARNING:
			echo "<b><u>PHP WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_NOTICE:
			break;

			default:
			echo "Unhandled error.<br><br>\n";
			break;
    	}

    	/* Don't execute PHP internal error handler */
    	return true;
	}
?>
<?php
	//Set new error handler
	$oeh=set_error_handler("eh");
	if(isset($_POST['s']) && $_POST['s'] == "y")
	{
		//Start submission
		if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			//Logging enabled on system
			$ip=$_SERVER['REMOTE_ADDR'];
			//Verify password
			if(file_exists("backend/password.txt"))
			{
				if(password_verify($_POST['pass'],base64_decode(file_get_contents("backend/password.txt"))) === true)
				{
					//Run the login routine
					login();
					$date=date("g:i:s");
					$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
					fwrite($fh,$ip . " at " . $date . ": Successfully entered admin mode\r\n");
					fclose($fh);
					//Get out of here
					echo ("<script type=\"text/javascript\">window.location = \"index.php?li=yes\"</script>");
				}
				else
				{
					//Trigger incorrect password error
					trigger_error("Invalid password entered",E_USER_WARNING);
					$date=date("g:i:s");
					$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
					fwrite($fh,$ip . " at " . $date . ": Entered invalid admin password\r\n");
					fclose($fh);
				}
			}
			else
			{
				//Password file cannot be opened
				trigger_error("Cannot validate password; the password file is in the pool!",E_USER_WARNING);
				$date=date("g:i:s");
				$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
				fwrite($fh,$ip . " at " . $date . ": Failed to validate password\r\n");
				fclose($fh);
			}
		}
		else
		{
			//Verify password
			if(file_exists("backend/password.txt"))
			{
				if(password_verify($_POST['pass'],base64_decode(file_get_contents("backend/password.txt"))) === true)
				{
					//Run the login routine
					login();
					//Get out of here
					echo ("<script type=\"text/javascript\">window.location = \"index.php?li=yes\"</script>");
				}
				else
				{
					//Trigger incorrect password error
					trigger_error("Invalid password entered",E_USER_WARNING);
				}
			}
			else
			{
				//Password file cannot be opened
				trigger_error("Cannot validate password; the password file is in the pool!",E_USER_WARNING);
			}
		}
	}
	else
	{
		if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			//Logging enabled on system
			$ip=$_SERVER['REMOTE_ADDR'];
			$date=date("g:i:s");
			$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			fwrite($fh,$ip . " at " . $date . ": Visited admin login page\r\n");
			fclose($fh);
		}
		if(securitycheck() === true)
		{
			//User is already an administrator!
			trigger_error("You are already an administrator! What are you doing here?");
			$disabled=true;
		}
		elseif(securitycheck() === false && isset($_SESSION['sradmin']) && $_SESSION['sradmin'] == "y")
		{
			//User logged in, but something wrong with security check
			trigger_error("The session you are attempting to use was partially microwaved. Perhaps it timed out, or perhaps you are a dodo bird and are trying to break in. Either way, you must log in again.");
		}
		if(!file_exists("backend/password.txt"))
		{
			//Password file does not exist, throw hands up in air
			trigger_error("The password file has been abducted by Russians, and the system cannot possibly log you in. Contact the software vendor.",E_USER_WARNING);
			$disabled=true;
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Login</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>MRS-Enter Administrative Mode</h1>
  <form method="post" action="login.php">
  <input type="hidden" name="s" value="y">
  Password: <input type="password" name="pass" required="required"><br>
  <input type="submit" <?php if($disabled === true) { echo ("disabled=\"disabled\""); } ?>><input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>