<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	//Function for displaying the page header
	function display_header($admin,$reqlvl,$posting,$logging,$vlist)
	{
		//First line: Login/out, Request, Admin (if applicable)
		//Second line: Banning stuff for admin, Rules+Contact otherwise
		//Third line: Quick view (for admins only)
		if($admin === true)
		{
			echo ("<a href=\"logout.php\">Exit Admin Mode</a> | <a href=\"post.php\">Request</a> | <a href=\"admin.php\">Administration</a> | <a href=\"about.php\">About the MRS</a><br>\r\n");
			echo ("<a href=\"bun.php\">Ban username</a> | <a href=\"vun.php\">View username banlist</a> | <a href=\"bip.php\">Ban IP address</a> | <a href=\"vip.php\">View IP banlist</a><br>\r\n");
			if($posting === true)
			{
				echo("Posting enabled | ");
			}
			else
			{
				echo("Posting disabled | ");
			}
			if($logging === true)
			{
				echo ("Logging enabled\r\n");
			}
			else
			{
				echo ("Logging disabled\r\n");
			}
		}
		else
		{
			/* Request levels:
			0-Closed
			1-Banned
			2-Open */
			switch($reqlvl)
			{
				case 0:
				echo ("<a href=\"login.php\">Enter Admin Mode</a> | ");
				echo ("Requesting disabled.");
				if($vlist === true)
				{
					echo (" <a href=\"post.php\">View Songs</a><br>\r\n");
				}
				else
				{
					echo ("<br>\r\n");
				}
				break;
				case 1:
				echo ("<strike>Enter Admin Mode</strike> | ");
				echo ("You are banned from making requests.<br>\r\n");
				break;
				case 2:
				echo ("<a href=\"login.php\">Enter Admin Mode</a> | ");
				echo ("<a href=\"post.php\">Request</a><br>\r\n");
				break;
				default:
				die(trigger_error("Invalid header level",E_USER_ERROR));
				break;
			}
			echo ("<a href=\"rules.php\">Request rules</a> | <a href=\"contact.php\">Contact us</a> | <a href=\"about.php\">About the MRS</a><br>\r\n");
		}
	}
	//Function for getting post contents
	function get_post_contents($post)
	{
		//Read file, decode it, then split it based on the new line character to get the contents
		return(explode("\r\n",base64_decode(file_get_contents($post))));
	}
    //Function for getting all open requests
    function get_open_reqs()
    {
        //Initialize
        $reqs=0;
        //Get all posts
        $files=glob("posts/*.txt");
        if(count($files) > 0)
        {
            //Loop through posts
            foreach($files as $file)
            {
                //Get contents
                $contents=get_post_contents($file);
                //Get only the status number
                $contents=explode("|",$contents[5]);
                $contents=$contents[0];
                //If number is not 1 (declined) or 3 (played), increment count
                if($contents == 0 || $contents == 2)
                {
                    $reqs++;
                }
            }
        }
        return $reqs;
    }
	//Function for determining post ability level
	function request_level($ip,$uname)
	{
		//Get state of system
        if(file_exists("backend/posting.txt"))
        {
            $open=file_get_contents("backend/posting.txt");
        }
        else
        {
            $open="no";
        }
		//Get ban lists (username list only needed if username cookie exists)
        if(file_exists("ban/ip.txt"))
        {
            $iplist=file_get_contents("ban/ip.txt");
        }
        else
        {
            $iplist="";
        }
		if($uname !== false)
		{
            if(file_exists("ban/uname.txt"))
            {
                $unlist=file_get_contents("ban/uname.txt");
            }
            else
            {
                $unlist="";
            }
		}
		if(strpos($iplist,$ip) !== false || ($uname !== false && strpos($unlist,$uname) !== false))
		{
			//User is banned
			return 1;
		}
        elseif(file_exists("backend/limit.txt") && file_get_contents("backend/limit.txt") > 0 && get_open_reqs() > file_get_contents("backend/limit.txt"))
        {
            //System in overflow mode
            return 0;
        }
		elseif($open == "yes")
		{
			//System is open
			return 2;
		}
		else
		{
			//Assume system is closed
			return 0;
		}
	}
	//Function for getting state of administrator privileges
	function is_admin()
	{
		if(securitycheck() === true)
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	//Function for getting state of request status viewing
	function can_view_state_as_nonuser()
	{
		if(file_exists("backend/status.txt") && file_get_contents("backend/status.txt") == "yes")
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	//Function for getting state of request system
	function is_open()
	{
		if(file_exists("backend/posting.txt") && file_get_contents("backend/posting.txt") == "yes")
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	//Function for determining if can view list when system closed
	function view_list_when_closed()
	{
		if(file_exists("backend/eroc.txt") && file_get_contents("backend/eroc.txt") == "yes")
		{
			return true;
		}
		else
		{
			return false;
		}
	}
	//Function for getting the post expiry time
	function get_expiry_time()
	{
		if(file_exists("backend/postexpiry.txt") && intval(file_get_contents("backend/postexpiry.txt")) > 0)
		{
			return intval(file_get_contents("backend/postexpiry.txt"));
		}
		else
		{
			return 0;
		}
	}
	//Function for displaying a post
	function display_request($admin,$uip,$sview,$open,$ctime,$id,$name,$ip,$date,$request,$status)
	{
		//Get time of post
		$time=strtotime($date);
		//Set initial opacity
		$opacity=1;
		//Separate status and comment
		$status=explode("|",$status);
		//Based on the status, set the opacity
		switch($status[0])
		{
			case 1:
			case 3:
			$opacity=0.5;
			break;
			case 2:
			$opacity=0.8;
			break;
			default:
			$opacity=1;
			break;
		}
		//If there is an "expiry" time set in the system, and the post has exceeded this expiry time while being either of declined or played, set opacity to minimum
		if(($status == 1 || $status == 3) && $ctime > 0 && ($time+$ctime) > time())
		{
			$opacity=0.2;
		}
		//Begin output string
		$string="<div style=\"opacity:$opacity\">" . $name;
		//Append IP address if and only if user is the same as requestee or user is admin.
		if($admin === true || $uip == $ip)
		{
			$string.=" with IP address " . $ip;
		}
		//Continue global output string
		$string.=" requested " . $request . " on " . $date . "<br>\r\n";
		//Display status if user is admin, same as requestee, or this functionality is enabled in the system
		if($admin === true || $uip == $ip || $sview === true)
		{
			switch($status[0])
			{
				case 0:
				$string .= "(Request has not been seen)";
				break;
				
				case 1:
				$string .= "(Request has been declined: " . $status[1] . ")";
				break;
				
				case 2:
				$string .= "(Request is in the queue, comment: " . $status[1] . ")";
				break;
				
				case 3:
				$string .= "(Request has been played, comment: " . $status[1] . ")";
				break;
				
				default:
				$string .= "(Request in indeterminate state)";
				break;
			}
			$string .= "<br>\r\n";
		}
		//Output options for request
		if($admin === true)
		{
			$string .= "<a href=\"delete.php?p=" . $id . "\">Delete</a> | <a href=\"edit.php?p=" . $id . "\">Edit</a> | <a href=\"queue.php?p=" . $id . "\">Put In Queue</a> | <a href=\"decline.php?p=" . $id . "\">Decline</a> | <a href=\"played.php?p=" . $id . "\">Mark as Played</a> | <a href=\"bun.php?p=" . $name . "\">Ban username</a> | <a href=\"bip.php?p=" . $ip . "\">Ban IP address</a>\r\n";
		}
		elseif($uip == $ip)
		{
			$string .= "<a href=\"delete.php?p=" . $id . "\">Delete</a>\r\n";
		}
		else
		{
			$string .= "<a href=\"report.php?p=" . $id . "\">Report this request</a>\r\n";
		}
		$string .= "</div>\r\n<hr>\r\n";
		//Print to the screen, unescaping where appropriate.
		echo stripcslashes($string);
	}
?>
<?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//System logging is enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$date=date("g:i:s");
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		fwrite($fh,$ip . " at " . $date . ": Visited main page\r\n");
		fclose($fh);
	}
?>
<?php
	//Custom error handler
	function eh($errno, $errstr, $errfile, $errline)
	{
		switch ($errno)
		{
			case E_USER_WARNING:
			echo "<b><u>WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_USER_NOTICE:
			echo "<b><u>NOTICE:</u></b> " . $errstr . "<br><br>\n";
			break;
			
			case E_WARNING:
			echo "<b><u>PHP WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_NOTICE:
			break;

			default:
			echo "Unhandled error.<br><br>\n";
			break;
    	}

    	/* Don't execute PHP internal error handler */
    	return true;
	}
	//Set error handler to the custom one
	$oeh=set_error_handler("eh");
	//Check for a submission status
	if(isset($_GET['status']) && $_GET['status'] != "")
	{
		switch($_GET['status'])
		{
			case 0:
			trigger_error("Request made successfully");
			break;
			case 2:
			trigger_error("Request failed: you are banned",E_USER_WARNING);
			break;
			case 1:
			trigger_error("Request failed: this system is like, uh, closed or something",E_USER_WARNING);
			break;
			case 3:
			trigger_error("Request failed: cannot submit a request without a name, valid IP or, well, a request!",E_USER_WARNING);
			break;
			case 4:
			trigger_error("Request failed: slow your role, breh",E_USER_WARNING);
			break;
			case 5:
			trigger_error("Request failed: ballot box stuffing detected!",E_USER_WARNING);
			break;
			case 6:
			trigger_error("Request failed: attempt to tip the boat over!",E_USER_WARNING);
			break;
			default:
			trigger_error("Request failed: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for a IP ban status
	if(isset($_GET['ipstatus']) && $_GET['ipstatus'] != "")
	{
		switch($_GET['ipstatus'])
		{
			case 0:
			trigger_error("IP address banned successfully");
			break;
			case 1:
			trigger_error("IP address ban failed: the IP address submitted was not valid and should be thrown into a swimming pool",E_USER_WARNING);
			break;
			default:
			trigger_error("IP address ban failed: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for a IP ban status
	if(isset($_GET['unstatus']) && $_GET['unstatus'] != "")
	{
		switch($_GET['unstatus'])
		{
			case 0:
			trigger_error("Username banned successfully");
			break;
			case 1:
			trigger_error("Username ban failed: the IP address submitted was not valid and should be thrown into a swimming pool",E_USER_WARNING);
			break;
			default:
			trigger_error("Username ban failed: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for a contact status
	if(isset($_GET['cstatus']) && $_GET['cstatus'] != "")
	{
		switch($_GET['cstatus'])
		{
			case 0:
			trigger_error("System reports that it successfully sent the contact information. Note that this does NOT mean that it was definitely sent; there is no way for the system to know that");
			break;
			case 1:
			trigger_error("Contact failed: the system administrator only had ONE JOB and did not set an email address to send to",E_USER_WARNING);
			break;
			default:
			trigger_error("Contact failed: microwaves and/or Russians got involved. Contact the webmaster via other means.",E_USER_WARNING);
			break;
		}
	}
	//Check for a decline status
	if(isset($_GET['decstatus']) && $_GET['decstatus'] != "")
	{
		switch($_GET['decstatus'])
		{
			case 0:
			trigger_error("Declined request successfully");
			break;
			case 1:
			trigger_error("Failed to decline request: the request to decline was either microwaved or dunked in a pool and could not be found",E_USER_WARNING);
			break;
			case 2:
			trigger_error("Failed to decline request: the request file requires to be either microwaved or dunked in a pool",E_USER_WARNING);
			break;
			default:
			trigger_error("Failed to decline request: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for a decline status
	if(isset($_GET['mapstatus']) && $_GET['mapstatus'] != "")
	{
		switch($_GET['mapstatus'])
		{
			case 0:
			trigger_error("Marked request as played successfully");
			break;
			case 1:
			trigger_error("Failed to mark request as played: the request to mark was either microwaved or dunked in a pool and could not be found",E_USER_WARNING);
			break;
			case 2:
			trigger_error("Failed to mark request as played: the request file requires to be either microwaved or dunked in a pool",E_USER_WARNING);
			break;
			default:
			trigger_error("Failed to mark request as played: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for a decline status
	if(isset($_GET['qstatus']) && $_GET['qstatus'] != "")
	{
		switch($_GET['qstatus'])
		{
			case 0:
			trigger_error("Queued request successfully");
			break;
			case 1:
			trigger_error("Failed to queue request: the request to queue was either microwaved or dunked in a pool and could not be found",E_USER_WARNING);
			break;
			case 2:
			trigger_error("Failed to queue request: the request file requires to be either microwaved or dunked in a pool",E_USER_WARNING);
			break;
			default:
			trigger_error("Failed to queue request: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for a delete status
	if(isset($_GET['delstatus']) && $_GET['delstatus'] != "")
	{
		switch($_GET['delstatus'])
		{
			case 0:
			trigger_error("Request deleted successfully");
			break;
			case 1:
			trigger_error("Failed to delete request: the request file requires to be either microwaved or dunked in a pool",E_USER_WARNING);
			break;
			case 2:
			trigger_error("Failed to delete request: the request to delete was either microwaved or dunked in a pool and could not be found",E_USER_WARNING);
			break;
			default:
			trigger_error("Failed to delete request: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check for an edit status
	if(isset($_GET['editstatus']) && $_GET['editstatus'] != "")
	{
		switch($_GET['editstatus'])
		{
			case 0:
			trigger_error("Request edited successfully");
			break;
			case 1:
			trigger_error("Failed to edit request: the request file requires to be either microwaved or dunked in a pool",E_USER_WARNING);
			break;
			case 2:
			trigger_error("Failed to edit request: the request to edit was either microwaved or dunked in a pool and could not be found",E_USER_WARNING);
			break;
			default:
			trigger_error("Failed to edit request: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Check login or logout status
	if(isset($_GET['li']) && $_GET['li'] == "yes")
	{
		trigger_error("Login successful.");
	}
	if(isset($_GET['lo']) && $_GET['lo'] == "yes")
	{
		trigger_error("Logout successful.");
	}
	//Check security change status
	if(isset($_GET['sc']) && $_GET['sc'] == "yes")
	{
		trigger_error("Security level changed. You have been logged out as a further security measure. Please log in again.");
	}
	//Check settings change status
	if(isset($_GET['admsave']) && $_GET['admsave'] == "yes")
	{
		trigger_error("Successfully changed system settings.");
	}
	//Check for a report status
	if(isset($_GET['repstatus']) && $_GET['repstatus'] != "")
	{
		switch($_GET['repstatus'])
		{
			case 0:
			trigger_error("System reports that it successfully sent the report. Note that this does NOT mean that it was definitely sent; there is no way for the system to know that");
			break;
			case 1:
			trigger_error("Report failed: the system administrator only had ONE JOB and did not set an email address to send to",E_USER_WARNING);
			break;
			case 2:
			trigger_error("Report failed: the system administrator has told system emails to go have you-know-what with a goose",E_USER_WARNING);
			break;
			case 3:
			trigger_error("Report failed: don't fiddle around with the post details or YOU will be microwaved!",E_USER_WARNING);
			break;
			case 4:
			trigger_error("Report failed: get off this system's lawn",E_USER_WARNING);
			break;
			case 5:
			trigger_error("Report failed: the report file was either microwaved or dunked in a pool and could not be found",E_USER_WARNING);
			break;
			default:
			trigger_error("Report failed: microwaves and/or Russians got involved. Contact the webmaster.",E_USER_WARNING);
			break;
		}
	}
	//Return to original error handler
	restore_error_handler();
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live show? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Main</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System</h1>
  <p>
  <?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//System logging is enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		//Set format for username (cookie contents if exists, false otherwise)
		if(!isset($_SESSION['uname']) || $_SESSION['uname'] == "")
		{
			$uname = false;
		}
		else
		{
			$uname = $_SESSION['uname'];
		}
		//Determine request level
		$level=request_level($ip,$uname);
		$date=date("g:i:s");
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		fwrite($fh,$ip . " at " . $date . ": Determed request level to be " . $level . "\r\n");
		//Display the header
		display_header(is_admin(),$level,is_open(),true,view_list_when_closed());
		fclose($fh);
	}
	else
	{
		$ip=$_SERVER['REMOTE_ADDR'];
		//Format username
		if(!isset($_SESSION['uname']) || $_SESSION['uname'] == "")
		{
			$uname = false;
		}
		else
		{
			$uname = $_SESSION['uname'];
		}
		//Determine request level
		$level=request_level($ip,$uname);
		//Output header
		display_header(is_admin(),$level,is_open(),false,view_list_when_closed());
	}
  ?>
  </p>
  <?php
	//Get number of all-time requests
	if(file_exists("backend/postid.txt"))
	{
		$requests=file_get_contents("backend/postid.txt");
	}
	else
	{
		$requests=0;
	}
	echo ("<h3>There have been a total of $requests all-time requests");
	if(file_exists("backend/light.txt") && file_get_contents("backend/light.txt") != "yes")
	{
		//Get list of songs
		if(file_exists("backend/songlist.txt"))
		{
			$sl=array_filter(explode("\r\n",file_get_contents("backend/songlist.txt")));
			$songs=count($sl);
			unset($sl);
		}
		else
		{
			$songs=0;
		}
		//Output # of songs
		echo (" made over $songs songs");
	}
	//Finish the line
	echo (".</h3>");
  ?>
  <?php
	//If logging in the system is enabled, warn the user this is the case
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		echo ("<h3>WARNING: Logging is enabled on this system! <a href=\"logging.php\">Learn more</a></h3>");
	}
  ?>
  <hr>
  <?php
	if(is_open() === false)
	{
		//MRS is closed
		echo ("<p>The MRS is presently disabled. You may not make requests.</p>\r\n");
		if(view_list_when_closed() === true)
		{
			//Viewing existing requests is allowed when system is closed
			echo ("<p>Previous requests can be viewed below.</p>\r\n<hr>\r\n");
		}
	}
	elseif($level == 1)
	{
		//User is banned
		echo("<p>You have been banned from this system. You may not look at existing requests or make any. Please contact the administrator for an explanation.</p>\r\n");
	}
	
	//Output each request if user is not banned, and the system is open, viewing requests when closed is allowed, or the user has admin privileges
	if($level != 1 && (is_open() === true || view_list_when_closed() === true || is_admin() === true))
	{
		if(is_admin() === true)
		{
			//Format fixing for admins
			echo ("<hr>\r\n");
		}
		//Get all requests, and sort them descending by number (correcting for POSIX' incorrect sort order)
		$requests=glob("posts/*.txt");
		natsort($requests);
		$requests=array_reverse($requests);
		if(count($requests) >= 1)
		{
			//There exists a request
			foreach($requests as $request)
			{
				//Get the contents of the request
				$contents=explode("\r\n",base64_decode(file_get_contents($request)));
				//Output the contents of the request
				display_request(is_admin(),$_SERVER['REMOTE_ADDR'],can_view_state_as_nonuser(),is_open(),get_expiry_time(),$contents[0],$contents[1],$contents[2],$contents[3],$contents[4],$contents[5]);
			}
		}
		else
		{
			//There are no requests
			echo ("<p>There are presently no requests on the MRS.</p>\r\n");
		}
	}
  ?>
  </p>
  </body>
</html>