<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Edit Request</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <?php
  	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(securitycheck() === true && isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
			//Sanitize the appropriate elements
			$post=preg_replace("/[^0-9]/","",$_POST['p']);
			$username=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['username']);
			$request=filter_var($_POST['request'],FILTER_SANITIZE_STRING);
			//Update file
			if(file_exists("posts/" . $post . ".txt"))
			{
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
				$contents[1]=stripcslashes($username);
				$contents[4]=stripcslashes(htmlspecialchars($request));
				$contents=base64_encode(implode("\r\n",$contents));
				$fh2=fopen("posts/" . $post . ".txt",'w');
				if($fh2)
				{
					fwrite($fh2,$contents);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Updated post \"" . $post . "\"\r\n");
					fclose($fh);
					fclose($fh2);
					echo ("<script type=\"text/javascript\">window.location = \"index.php?editstatus=0\"</script>");
				}
				else
				{
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Failed to update post \"" . $post . "\"\r\n");
					fclose($fh);
					echo ("<script type=\"text/javascript\">window.location = \"index.php?editstatus=1\"</script>");
				}
			}
			else
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Failed to update post \"" . $post . "\"\r\n");
				fclose($fh);
				echo ("<script type=\"text/javascript\">window.location = \"index.php?editstatus=2\"</script>");
			}
		}
		elseif(securitycheck() === true)
		{
			//Sanitize post number
			$post=preg_replace("/[^0-9]/","",$_GET['p']);
			//Get file info
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited edit page for post \"" . $post . "\"\r\n");
			if(file_exists("posts/" . $post . ".txt"))
			{
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Obtained details for post \"" . $post . "\"\r\n");
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
			}
			else
			{
				fwrite($fh,$ip . " at " . $date . ": Encountered error obtaining details for post \"" . $post . "\"\r\n");
				fclose($fh);
				die("Failed to obtain request information for post #$post. Microwave the file immediately.");
			}
			fclose($fh);
		}
		else
		{
			//Nope.
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited edit page for post \"" . $post . "\"\r\n");
			fclose($fh);
			die("You are not authorized to edit this post. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
		}
	}
	else
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging disabled
		if(securitycheck() === true && isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
			//Sanitize the appropriate elements
			$post=preg_replace("/[^0-9]/","",$_POST['p']);
			$username=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['username']);
			$request=filter_var($_POST['request'],FILTER_SANITIZE_STRING);
			//Update file
			if(file_exists("posts/" . $post . ".txt"))
			{
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
				$contents[1]=stripcslashes($username);
				$contents[4]=stripcslashes(htmlspecialchars($request));
				$contents=base64_encode(implode("\r\n",$contents));
				$fh2=fopen("posts/" . $post . ".txt",'w');
				if($fh2)
				{
					fwrite($fh2,$contents);
					fclose($fh2);
					echo ("<script type=\"text/javascript\">window.location = \"index.php?editstatus=0\"</script>");
				}
				else
				{
					echo ("<script type=\"text/javascript\">window.location = \"index.php?editstatus=1\"</script>");
				}
			}
			else
			{
				echo ("<script type=\"text/javascript\">window.location = \"index.php?editstatus=2\"</script>");
			}
		}
		elseif(securitycheck() === true)
		{
			//Sanitize post number
			$post=preg_replace("/[^0-9]/","",$_GET['p']);
			//Get file info
			if(file_exists("posts/" . $post . ".txt"))
			{
				$contents=explode("\r\n",base64_decode(file_get_contents("posts/" . $post . ".txt")));
			}
			else
			{
				die("Failed to obtain request information for post #$post. Microwave the file immediately.");
			}
		}
		else
		{
			//Nope.
			die("You are not authorized to edit this post. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
		}
	}
  ?>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System-Edit Post #<?php echo $post; ?></h1>
  <form method="post" action="edit.php">
  <input type="hidden" name="confirm" value="y">
  <input type="hidden" name="p" value="<?php echo $post; ?>">
  Username: <input type="text" name="username" value="<?php echo $contents[1]; ?>"><br>
  Request: <input type="text" name="request" value="<?php echo $contents[4]; ?>"><br>
  <input type="submit" value="Confirm"> or <input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>