<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Contact Administrator</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
            //Sanitize email address
            $from=filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
			//Write email string
			$string="User " . $_POST['uname'] . " (whose email address is in the \"from\" field) with IP address " . $_POST['ip'] . " on " . $_POST['date'] . " wrote the following:\r\n";
			//NOTE: trim whitespace before sanitizing!
			$string.=trim($_POST['comment']);
			//Sanitize string
			$string=filter_var($string,FILTER_SANITIZE_STRING);
			//Get the email address to send the request to
			if(file_exists("backend/email.txt") && file_get_contents("backend/email.txt") != "")
			{
				//Safe to proceed with email
				$email=base64_decode(file_get_contents("backend/email.txt"));
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Obtained email address to send report to\r\n");
				//Send email
				$debug=mail($email,"Comment submitted by the MRS",$string,"From: " . $from);
				if($debug === true)
				{
					//Success
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Successfully sent email for comment\r\n");
				}
				else
				{
					//Failure
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Failed to email for comment\r\n");
				}
			}
			else
			{
				//Unsafe to proceed
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": No email address found, can't send\r\n");
				fclose($fh);
				echo ("<script type=\"text/javascript\">window.location = \"index.php?cstatus=1\"</script>");
			}
			fclose($fh);
			//Get out of here
			echo ("<script type=\"text/javascript\">window.location = \"index.php?cstatus=0\"</script>");
		}
		else
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Visited contact page\r\n");
			$sendate=date("m/d/Y g:i A");
			if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") != "yes")
			{
				$disabled=true;
			}
			fclose($fh);
		}
	}
	else
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging disabled
		if(isset($_POST['confirm']) && $_POST['confirm'] == "y")
		{
            //Sanitize email address
            $from=filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
			//Write email string
			$string="User " . $_POST['uname'] . " (whose email address is in the \"from\" field) with IP address " . $_POST['ip'] . " on " . $_POST['date'] . " wrote the following:\r\n";
			//NOTE: trim whitespace before sanitizing!
			$string.=trim($_POST['comment']);
			//Sanitize string
			$string=filter_var($string,FILTER_SANITIZE_STRING);
			//Get the email address to send the request to
			if(file_exists("backend/email.txt") && file_get_contents("backend/email.txt") != "")
			{
				//Safe to proceed with email
				$email=base64_decode(file_get_contents("backend/email.txt"));
				//Send email
				mail($email,"Comment submitted by the MRS",$string,"From: " . $from);
			}
			else
			{
				//Unsafe to proceed
				echo ("<script type=\"text/javascript\">window.location = \"index.php?cstatus=1\"</script>");
			}
			//Get out of here
			echo ("<script type=\"text/javascript\">window.location = \"index.php?cstatus=0\"</script>");
		}
		else
		{
			$sendate=date("m/d/Y g:i A");
			if(file_exists("backend/sendmail.txt") && file_get_contents("backend/sendmail.txt") != "yes")
			{
				$disabled=true;
			}
		}
	}
  ?>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>Music Request System-Contact</h1>
  <?php
	if($disabled === true)
	{
		echo ("<p>Unfortunately, the system administrator has <b>disabled</b> the ability for this system to send emails, therefore this form will not work. You must contact them by other means.</p>");
	}
  ?>
  <form method="post" action="contact.php">
  <input type="hidden" name="confirm" value="y">
  <input type="hidden" name="ip" value="<?php echo $_SERVER['REMOTE_ADDR']; ?>">
  <input type="hidden" name="date" value="<?php echo $sendate; ?>">
  Name: <input type="text"  name="name" value="<?php if(isset($_SESSION['uname'])) {echo $_SESSION['uname']; } else { echo ("Anonymous"); } ?>" required="required"> (do not touch the contents of this box if you either do not wish to submit a name at all or do not want to change it)<br>
  Email address (required): <input type="text" name="email" required="required"><br>
  Comments (required):<br>
  <textarea name="comment" required="required" rows="10" cols="50"></textarea><br>
  <input type="submit" value="Send message" <?php if($disabled === true) { echo "disabled=\"disabled\""; } ?>> or <input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>