<?php
	function checkflag()
	{
		//Check for a set admin flag in the session
		if(isset($_SESSION['sradmin']) && $_SESSION['sradmin'] == "y")
		{
			//Valid
			return true;
		}
		//Invalid
		return false;
	}
	function checkip()
	{
		//Check for a set IP in the session and that it matches the user's IP
		if(isset($_SESSION['ip']) && $_SESSION['ip'] != "" && $_SESSION['ip'] == $_SERVER['REMOTE_ADDR'])
		{
			//Valid
			return true;
		}
		//Invalid
		return false;
	}
	function checkua()
	{
		//Check for a set useragent in the session and that it matches the user's IP
		if(isset($_SESSION['ua']) && $_SESSION['ua'] == $_SERVER['HTTP_USER_AGENT'])
		{
			//Valid
			return true;
		}
		//Invalid
		return false;
	}
	function checkid()
	{
		//Check for a unique ID
		if(isset($_SESSION['identifier']) && $_SESSION['identifier'] != "" && intval($_SESSION['identifier']) >= 0 && intval($_SESSION['identifier']) <= 2000000)
		{
			//Valid
			return true;
		}
		//Invalid
		return false;
	}
	function securitycheck()
	{
		//Check for a security file
		if(file_exists("backend/security.txt") && file_get_contents("backend/security.txt") != "")
		{
			switch(intval(file_get_contents("backend/security.txt")))
			{
				case 1:
				$flag=checkflag();
				$ip=checkip();
				$ua=true;
				$id=true;
				break;
				case 2:
				$flag=checkflag();
				$ip=true;
				$ua=checkua();
				$id=true;
				break;
				case 3:
				$flag=checkflag();
				$ip=checkip();
				$ua=checkua();
				$id=true;
				break;
				case 4:
				$flag=checkflag();
				$ip=true;
				$ua=true;
				$id=checkid();
				break;
				case 5:
				$flag=checkflag();
				$ip=checkip();
				$ua=true;
				$id=checkid();
				break;
				case 6:
				$flag=checkflag();
				$ip=true;
				$ua=checkua();
				$id=checkid();
				break;
				case 7:
				$flag=checkflag();
				$ip=checkip();
				$ua=checkua();
				$id=checkid();
				break;
				default:
				$flag=checkflag();
				$ip=true;
				$ua=true;
				$id=true;
				break;
			}
			if($flag === true && $ip === true && $ua === true && $id === true)
			{
				//Valid login
				return true;
			}
		}
		else
		{
			//Use safe (but potentially less secure) fallback
			if(isset($_SESSION['sradmin']) && $_SESSION['sradmin'] == "y")
			{
				return true;
			}
		}
		//No security check passed, user is not an administrator
		return false;
	}
?>