<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Archive Posts</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>MRS-Archive Posts</h1>
<?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled
		$ip=$_SERVER['REMOTE_ADDR'];
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		if(isset($_GET['s']) && $_GET['s'] == "y")
		{
			//Archive posts
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Began archiving posts\r\n");
			$files=glob("posts/*.txt");
			foreach($files as $file)
			{
				$newfile=str_replace("posts","archive",$file);
				echo("Saving file \"$file\" to \"$newfile\"...");
				$contents=stripcslashes(base64_decode(file_get_contents($file)));
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Read and decoded file \"" . $file . "\"\r\n");
				$fh2=fopen($newfile,'w');
				if($fh2)
				{
					//Success
					fwrite($fh2,$contents);
					fclose($fh2);
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Successfully wrote archive file \"" . $newfile . "\"\r\n");
					echo ("DONE.<br>\r\n");
				}
				else
				{
					//Failure
					$date=date("g:i:s");
					fwrite($fh,$ip . " at " . $date . ": Failed to write archive file \"" . $newfile . "\"\r\n");
					echo ("FAILED. Microwave the source file or the destination folder.<br>\r\n");
				}
			}
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Successfully wrote all archive files\r\n");
			fclose($fh);
			echo("Completed process. Check above for errors.<br>\r\n<a href=\"admin.php\">Finish</a>\r\n");
		}
		else
		{
			//Just show page
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Viewed archive page\r\n");
			fclose($fh);
			if(securitycheck() === false)
			{
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			}
			echo ("<p>Post archival will unencrypt all of the current posts into an identically named file in the archive subdirectory in the system. It will not delete any existing files.</p>\r\n<a href=\"archive.php?s=y\">Archive posts</a> or <a href=\"admin.php\">Cancel</a>");
		}
	}
	else
	{
		//Logging disabled
		if(isset($_GET['s']) && $_GET['s'] == "y")
		{
			//Archive posts
			$files=glob("posts/*.txt");
			foreach($files as $file)
			{
				$newfile=str_replace("posts","archive",$file);
				echo("Saving file \"$file\" to \"$newfile\"...");
				$contents=stripcslashes(base64_decode(file_get_contents($file)));
				$fh2=fopen($newfile,'w');
				if($fh2)
				{
					//Success
					fwrite($fh2,$contents);
					fclose($fh2);
					echo ("DONE.<br>\r\n");
				}
				else
				{
					echo ("FAILED. Microwave the source file or the destination folder.<br>\r\n");
				}
			}
			echo("Completed process. Check above for errors.<br>\r\n<a href=\"admin.php\">Finish</a>\r\n");
		}
		else
		{
			//Just show page
			if(securitycheck() === false)
			{
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			}
			echo ("<p>Post archival will unencrypt all of the current posts into an identically named file in the archive subdirectory in the system. It will not delete any existing files.</p>\r\n<a href=\"archive.php?s=y\">Archive posts</a> or <a href=\"admin.php\">Cancel</a>");
		}
	}
?>
  </body>
</html>