<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Open session
	session_start();
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	//Custom error handler
	function eh($errno, $errstr, $errfile, $errline)
	{
		switch ($errno)
		{
			case E_USER_WARNING:
			echo "<b><u>WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_USER_NOTICE:
			echo "<b><u>NOTICE:</u></b> " . $errstr . "<br><br>\n";
			break;
			
			case E_WARNING:
			echo "<b><u>PHP WARNING:</u></b> " . $errstr . "<br><br>\n";
			break;

			case E_NOTICE:
			break;

			default:
			echo "Unhandled error.<br><br>\n";
			break;
    	}

    	/* Don't execute PHP internal error handler */
    	return true;
	}
	//Set error handler to the custom one
	$oeh=set_error_handler("eh");
	//Check for a "first use" flag file and notify the admin that they should change the poassword
	if(file_exists("backend/firstuse.txt"))
	{
		trigger_error("The administrator password is the default! Please consider changing it.",E_USER_WARNING);
	}
?>
<?php
	//Ancilliary page error handlers
	if(isset($_GET['slstatus']))
	{
		if($_GET['slstatus'] == 0)
		{
			echo ("Successfully changed song list.<br>\r\n");
		}
		elseif($_GET['slstatus'] == 1)
		{
			echo ("Failed to change song list. The list requires prompt microwaving.<br>\r\n");
		}
		else
		{
			echo ("Failed to change song list. Some wicked unidentifiable problem occurred and the whole system needs prompt microwaving.<br>\r\n");
		}
	}
	if(isset($_GET['blstatus']))
	{
		if($_GET['blstatus'] == 0)
		{
			echo ("Successfully changed base list.<br>\r\n");
		}
		elseif($_GET['blstatus'] == 1)
		{
			echo ("Failed to change base list. The list requires prompt microwaving.<br>\r\n");
		}
		else
		{
			echo ("Failed to change base list. Some wicked unidentifiable problem occurred and the whole system needs prompt microwaving.<br>\r\n");
		}
	}
	if(isset($_GET['pchange']))
	{
		if($_GET['pchange'] == 0)
		{
			echo ("Successfully changed password.<br>\r\n");
		}
		elseif($_GET['pchange'] == 1)
		{
			echo ("Failed to change password: user had ONE JOB and the old password given was incorrect.<br>\r\n");
		}
		elseif($_GET['pchange'] == 2)
		{
			echo ("Failed to change password: user had ONE JOB and the new password did not verify.<br>\r\n");
		}
		elseif($_GET['pchange'] == 3)
		{
			echo ("Failed to change password: the password file was dunked in a pool and couldn't be found or opened.<br>\r\n");
		}
		else
		{
			echo ("Failed to change password. Some wicked unidentifiable problem occurred and the whole system needs prompt microwaving.<br>\r\n");
		}
	}
	if(isset($_GET['rl']))
	{
		if($_GET['rl'] == 0)
		{
			echo ("Successfully changed rule list.<br>\r\n");
		}
		else
		{
			echo ("Failed to change rule list. Some wicked unidentifiable problem occurred and the whole system needs prompt microwaving.<br>\r\n");
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-Administration</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
<?php
	if(isset($_POST['s']) && $_POST['s'] == "y")
	{
		//Begin submission
		if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			//Logging is enabled
			$ip=$_SERVER['REMOTE_ADDR'];
			$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			//Change whether a user can submit requests anonymously or not
			if(isset($_POST['anon']) && $_POST['anon'] != "" && $_POST['canon'] != $_POST['anon'])
			{
				$fh2=fopen("backend/anon.txt",'w') or die ("Failed to save setting \"anon\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['anon']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-anonymous request\r\n");
			}
			//Enable/disable system logging
			if(isset($_POST['logging']) && $_POST['logging'] != "" && $_POST['clogging'] != $_POST['logging'])
			{
				$fh2=fopen("backend/logging.txt",'w') or die ("Failed to save setting \"logging\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['logging']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-track logging\r\n");
			}
			//Enable/disable custom requests
			if(isset($_POST['open']) && $_POST['open'] != "" && $_POST['copen'] != $_POST['open'])
			{
				$fh2=fopen("backend/open.txt",'w') or die ("Failed to save setting \"open\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['open']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-open request\r\n");
			}
			//Enable/disable the system
			if(isset($_POST['posting']) && $_POST['posting'] != "" && $_POST['cposting'] != $_POST['posting'])
			{
				$fh2=fopen("backend/posting.txt",'w') or die ("Failed to save setting \"posting\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['posting']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-system request restriction\r\n");
			}
			//Change the time of request restriction
			if(isset($_POST['type']) && $_POST['type'] != "" && $_POST['ctype'] != $_POST['type'])
			{
				$fh2=fopen("backend/type.txt",'w') or die ("Failed to save setting \"type\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['type']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-restrict time\r\n");
			}
			//Change username request retriction
			if(isset($_POST['unlock']) && $_POST['unlock'] != "" && $_POST['cunlock'] != $_POST['unlock'])
			{
				$fh2=fopen("backend/unlock.txt",'w') or die ("Failed to save setting \"unlock\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['unlock']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-username request restriction\r\n");
			}
			//Change IP request restriction
			if(isset($_POST['iplock']) && $_POST['iplock'] != "" && $_POST['ciplock'] != $_POST['iplock'])
			{
				$fh2=fopen("backend/iplock.txt",'w') or die ("Failed to save setting \"iplock\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['iplock']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-IP address request restriction\r\n");
			}
			//Change overall request restriction per day
			if(isset($_POST['dayrestrict']) && $_POST['dayrestrict'] != "" && $_POST['cdayrestrict'] != $_POST['dayrestrict'])
			{
				$fh2=fopen("backend/dayrestrict.txt",'w') or die ("Failed to save setting \"dayrestrict\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['dayrestrict']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-general request restriction\r\n");
			}
			//Enable/disable request status viewing by everyone
			if(isset($_POST['status']) && $_POST['status'] != "" && $_POST['cstatus'] != $_POST['status'])
			{
				$fh2=fopen("backend/status.txt",'w') or die ("Failed to save setting \"status\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['status']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-request status view\r\n");
			}
			//Enable/disable viewing requests and songs while system closed
			if(isset($_POST['eroc']) && $_POST['eroc'] != "" && $_POST['ceroc'] != $_POST['eroc'])
			{
				$fh2=fopen("backend/eroc.txt",'w') or die ("Failed to save setting \"eroc\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['eroc']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-enable request viewing while closed\r\n");
			}
			//Enable/disable making requests while a request by the user is already pending
			if(isset($_POST['pdreq']) && $_POST['pdreq'] != "" && $_POST['cpdreq'] != $_POST['pdreq'])
			{
				$fh2=fopen("backend/pdreq.txt",'w') or die ("Failed to save setting \"pdreq\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['pdreq']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-disallow requests when user has an open request\r\n");
			}
			//Enable/disable searching
			if(isset($_POST['search']) && $_POST['search'] != "" && $_POST['csearch'] != $_POST['search'])
			{
				$fh2=fopen("backend/searching.txt",'w') or die ("Failed to save setting \"searching\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['search']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-allow searching\r\n");
			}
			//Change list of words to strip
			if($_POST['cstripwords'] != $_POST['stripwords'])
			{
				$fh2=fopen("backend/stripwords.txt",'w') or die ("Failed to save setting \"stripwords\" as the backend only had ONE JOB!");
				$stripwords=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['stripwords']);
				fwrite($fh2,$stripwords);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed list of words to strip from requests\r\n");
			}
			//Enable/disable mailing
			if(isset($_POST['domail']) && $_POST['domail'] != "" && $_POST['cdomail'] != $_POST['domail'])
			{
				$fh2=fopen("backend/sendmail.txt",'w') or die ("Failed to save setting \"sendmail\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['domail']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-admin email address\r\n");
			}
			//Change admin email
			if(isset($_POST['email']) && $_POST['email'] != "" && $_POST['cemail'] != $_POST['email'])
			{
				$fh2=fopen("backend/email.txt",'w') or die ("Failed to save setting \"email address\" as the backend only had ONE JOB!");
				$email=filter_var($_POST['email'],FILTER_SANITIZE_EMAIL);
				fwrite($fh2,base64_encode($email));
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-admin email address\r\n");
			}
			//Change timezone
			if(isset($_POST['zone']) && $_POST['zone'] != "" && $_POST['czone'] != $_POST['zone'])
			{
				$fh2=fopen("backend/timezone.txt",'w') or die ("Failed to save setting \"timezone\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['zone']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-system timezone\r\n");
			}
			//Change system name
			if($_POST['cname'] != $_POST['name'])
			{
				//Sanitize before entry
				$sname=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['name']);
				$fh2=fopen("backend/name.txt",'w') or die ("Failed to save setting \"sysname\" as the backend only had ONE JOB!");
				fwrite($fh2,$sname);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-system name\r\n");
			}
			//Change system overflow setting
			if(isset($_POST['overflow']) && $_POST['overflow'] != "" && $_POST['coverflow'] != $_POST['overflow'])
			{
				$fh2=fopen("backend/limit.txt",'w') or die ("Failed to save setting \"overflow\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['overflow']);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-system overflow level\r\n");
			}
			//Change system upgrade setting
			if(isset($_POST['upgrade']) && $_POST['upgrade'] != "" && $_POST['cupgrade'] != $_POST['upgrade'])
			{
				//Sanitize!
				if($_POST['upgrade'] != "yes")
				{
					$upgrade="no";
				}
				else
				{
					$upgrade="yes";
				}
				$fh2=fopen("backend/stable.txt",'w') or die ("Failed to save setting \"upgrade\" as the backend only had ONE JOB!");
				fwrite($fh2,$upgrade);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-system upgrading\r\n");
			}
			//Change light mode setting
			if(isset($_POST['light']) && $_POST['light'] != "" && $_POST['clight'] != $_POST['light'])
			{
				//Sanitize!
				if($_POST['light'] != "no")
				{
					$light="yes";
				}
				else
				{
					$light="no";
				}
				$fh2=fopen("backend/light.txt",'w') or die ("Failed to save setting \"light\" as the backend only had ONE JOB!");
				fwrite($fh2,$light);
				fclose($fh2);
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Changed setting-light mode\r\n");
			}
			fclose($fh);
			//Return to the home page
			echo("<script type=\"text/javascript\">window.location = \"index.php?admsave=yes\"</script>");
		}
		else
		{
			if(isset($_POST['anon']) && $_POST['anon'] != "" && $_POST['canon'] != $_POST['anon'])
			{
				$fh2=fopen("backend/anon.txt",'w') or die ("Failed to save setting \"anon\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['anon']);
				fclose($fh2);
			}
			//Enable/disable system logging
			if(isset($_POST['logging']) && $_POST['logging'] != "" && $_POST['clogging'] != $_POST['logging'])
			{
				$fh2=fopen("backend/logging.txt",'w') or die ("Failed to save setting \"logging\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['logging']);
				fclose($fh2);
			}
			//Enable/disable custom requests
			if(isset($_POST['open']) && $_POST['open'] != "" && $_POST['copen'] != $_POST['open'])
			{
				$fh2=fopen("backend/open.txt",'w') or die ("Failed to save setting \"open\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['open']);
				fclose($fh2);
			}
			//Enable/disable the system
			if(isset($_POST['posting']) && $_POST['posting'] != "" && $_POST['cposting'] != $_POST['posting'])
			{
				$fh2=fopen("backend/posting.txt",'w') or die ("Failed to save setting \"posting\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['posting']);
				fclose($fh2);
			}
			//Change the time of request restriction
			if(isset($_POST['type']) && $_POST['type'] != "" && $_POST['ctype'] != $_POST['type'])
			{
				$fh2=fopen("backend/type.txt",'w') or die ("Failed to save setting \"type\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['type']);
				fclose($fh2);
			}
			//Change username request retriction
			if(isset($_POST['unlock']) && $_POST['unlock'] != "" && $_POST['cunlock'] != $_POST['unlock'])
			{
				$fh2=fopen("backend/unlock.txt",'w') or die ("Failed to save setting \"unlock\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['unlock']);
				fclose($fh2);
			}
			//Change IP request restriction
			if(isset($_POST['iplock']) && $_POST['iplock'] != "" && $_POST['ciplock'] != $_POST['iplock'])
			{
				$fh2=fopen("backend/iplock.txt",'w') or die ("Failed to save setting \"iplock\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['iplock']);
				fclose($fh2);
			}
			//Change overall request restriction per day
			if(isset($_POST['dayrestrict']) && $_POST['dayrestrict'] != "" && $_POST['cdayrestrict'] != $_POST['dayrestrict'])
			{
				$fh2=fopen("backend/dayrestrict.txt",'w') or die ("Failed to save setting \"dayrestrict\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['dayrestrict']);
				fclose($fh2);
			}
			//Enable/disable request status viewing by everyone
			if(isset($_POST['status']) && $_POST['status'] != "" && $_POST['cstatus'] != $_POST['status'])
			{
				$fh2=fopen("backend/status.txt",'w') or die ("Failed to save setting \"status\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['status']);
				fclose($fh2);
			}
			//Enable/disable viewing requests and songs while system closed
			if(isset($_POST['eroc']) && $_POST['eroc'] != "" && $_POST['ceroc'] != $_POST['eroc'])
			{
				$fh2=fopen("backend/eroc.txt",'w') or die ("Failed to save setting \"eroc\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['eroc']);
				fclose($fh2);
			}
			//Enable/disable making requests while a request by the user is already pending
			if(isset($_POST['pdreq']) && $_POST['pdreq'] != "" && $_POST['cpdreq'] != $_POST['pdreq'])
			{
				$fh2=fopen("backend/pdreq.txt",'w') or die ("Failed to save setting \"pdreq\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['pdreq']);
				fclose($fh2);
			}
			//Enable/disable searching
			if(isset($_POST['search']) && $_POST['search'] != "" && $_POST['csearch'] != $_POST['search'])
			{
				$fh2=fopen("backend/searching.txt",'w') or die ("Failed to save setting \"searching\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['search']);
				fclose($fh2);
			}
			//Change list of words to strip
			if($_POST['cstripwords'] != $_POST['stripwords'])
			{
				$fh2=fopen("backend/stripwords.txt",'w') or die ("Failed to save setting \"stripwords\" as the backend only had ONE JOB!");
				$stripwords=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['stripwords']);
				fwrite($fh2,$stripwords);
				fclose($fh2);
			}
			//Enable/disable mailing
			if(isset($_POST['domail']) && $_POST['domail'] != "" && $_POST['cdomail'] != $_POST['domail'])
			{
				$fh2=fopen("backend/sendmail.txt",'w') or die ("Failed to save setting \"sendmail\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['domail']);
				fclose($fh2);
			}
			//Change admin email
			if(isset($_POST['email']) && $_POST['email'] != "" && $_POST['cemail'] != $_POST['email'])
			{
				$fh2=fopen("backend/email.txt",'w') or die ("Failed to save setting \"email address\" as the backend only had ONE JOB!");
				$email=filter_var($_POST['email'],FILTER_SANITIZE_EMAIL);
				fwrite($fh2,base64_encode($email));
				fclose($fh2);
			}
			//Change timezone
			if(isset($_POST['zone']) && $_POST['zone'] != "" && $_POST['czone'] != $_POST['zone'])
			{
				$fh2=fopen("backend/timezone.txt",'w') or die ("Failed to save setting \"timezone\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['zone']);
				fclose($fh2);
			}
			//Change system name
			if($_POST['cname'] != $_POST['name'])
			{
				//Sanitize before entry
				$sname=preg_replace("/[^A-Za-z0-9 ]/", "", $_POST['name']);
				$fh2=fopen("backend/name.txt",'w') or die ("Failed to save setting \"sysname\" as the backend only had ONE JOB!");
				fwrite($fh2,$sname);
				fclose($fh2);
			}
			//Change system overflow setting
			if(isset($_POST['overflow']) && $_POST['overflow'] != "" && $_POST['coverflow'] != $_POST['overflow'])
			{
				$fh2=fopen("backend/limit.txt",'w') or die ("Failed to save setting \"overflow\" as the backend only had ONE JOB!");
				fwrite($fh2,$_POST['overflow']);
				fclose($fh2);
			}
			//Change system upgrade setting
			if(isset($_POST['upgrade']) && $_POST['upgrade'] != "" && $_POST['cupgrade'] != $_POST['upgrade'])
			{
				//Sanitize!
				if($_POST['upgrade'] != "yes")
				{
					$upgrade="no";
				}
				else
				{
					$upgrade="yes";
				}
				$fh2=fopen("backend/stable.txt",'w') or die ("Failed to save setting \"upgrade\" as the backend only had ONE JOB!");
				fwrite($fh2,$upgrade);
				fclose($fh2);
			}
			//Change light mode setting
			if(isset($_POST['light']) && $_POST['light'] != "" && $_POST['clight'] != $_POST['light'])
			{
				//Sanitize!
				if($_POST['light'] != "no")
				{
					$light="yes";
				}
				else
				{
					$light="no";
				}
				$fh2=fopen("backend/light.txt",'w') or die ("Failed to save setting \"light\" as the backend only had ONE JOB!");
				fwrite($fh2,$light);
				fclose($fh2);
			}
			echo("<script type=\"text/javascript\">window.location = \"index.php?admsave=yes\"</script>");
		}
	}
	else
	{
		//Get status of the system (only if administrator!)
		if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
		{
			//Change the timezone
			if(file_exists("backend/timezone.txt"))
			{
				date_default_timezone_set(file_get_contents("backend/timezone.txt"));
			}
			else
			{
				date_default_timezone_set("America/Toronto");
			}
			$ip=$_SERVER['REMOTE_ADDR'];
			$date=date("g:i:s");
			$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
			fwrite($fh,$ip . " at " . $date . ": Visited administration page\r\n");
			if(securitycheck() === false)
			{
				fclose($fh);
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			}
			if(file_exists("backend/anon.txt"))
			{
				$anon=file_get_contents("backend/anon.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-anonymous request (from system)\r\n");
			}
			else
			{
				$anon="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-anonymous request (default)\r\n");
			}
			if(file_exists("backend/logging.txt"))
			{
				$logging=file_get_contents("backend/logging.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-track logging (from system)\r\n");
			}
			else
			{
				$logging="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-track logging (default)\r\n");
			}
			if(file_exists("backend/open.txt"))
			{
				$open=file_get_contents("backend/open.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-open request (from system)\r\n");
			}
			else
			{
				$open="yes";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-open request (default)\r\n");
			}
			if(file_exists("backend/posting.txt"))
			{
				$posting=file_get_contents("backend/posting.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system request restriction (from system)\r\n");
			}
			else
			{
				$posting="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system request restriction (default)\r\n");
			}
			if(file_exists("backend/type.txt"))
			{
				$type=file_get_contents("backend/type.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-restrict time (from system)\r\n");
			}
			else
			{
				$type=0;
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-restrict time (default)\r\n");
			}
			if(file_exists("backend/unlock.txt"))
			{
				$unlock=file_get_contents("backend/unlock.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-username request restriction (from system)\r\n");
			}
			else
			{
				$unlock=2;
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-username request restriction (default)\r\n");
			}
			if(file_exists("backend/iplock.txt"))
			{
				$iplock=file_get_contents("backend/iplock.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-IP address request restriction (from system)\r\n");
			}
			else
			{
				$iplock=5;
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-IP address request restriction (default)\r\n");
			}
			if(file_exists("backend/dayrestrict.txt"))
			{
				$daylock=file_get_contents("backend/dayrestrict.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-general request restriction (from system)\r\n");
			}
			else
			{
				$daylock=10;
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-general request restriction (default)\r\n");
			}
			if(file_exists("backend/status.txt"))
			{
				$status=file_get_contents("backend/status.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-view request status (from system)\r\n");
			}
			else
			{
				$status="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-view request status (default)\r\n");
			}
			if(file_exists("backend/eroc.txt"))
			{
				$eroc=file_get_contents("backend/eroc.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-enable request viewing when closed (from system)\r\n");
			}
			else
			{
				$eroc="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-enable request viewing when closed (default)\r\n");
			}
			if(file_exists("backend/pdreq.txt"))
			{
				$pdreq=file_get_contents("backend/pdreq.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-disable requests when user has an open request (from system)\r\n");
			}
			else
			{
				$pdreq="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-disable requests when user has an open request (default)\r\n");
			}
			if(file_exists("backend/searching.txt"))
			{
				$search=file_get_contents("backend/searching.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-allow searching (from system)\r\n");
			}
			else
			{
				$search="yes";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-allow searching (default)\r\n");
			}
			if(file_exists("backend/stripwords.txt"))
			{
				$stripwords=file_get_contents("backend/stripwords.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got list of words to strip from request (from system)\r\n");
			}
			else
			{
				$stripwords="";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got list of words to strip from request (default)\r\n");
			}
			if(file_exists("backend/sendmail.txt"))
			{
				$sendmail=file_get_contents("backend/sendmail.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-send mail (from system)\r\n");
			}
			else
			{
				$sendmail="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-send mail (default)\r\n");
			}
			if(file_exists("backend/email.txt"))
			{
				$email=base64_decode(file_get_contents("backend/email.txt"));
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-admin email address (from system)\r\n");
			}
			else
			{
				$email="";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-admin email address (default)\r\n");
			}
			if(file_exists("backend/timezone.txt"))
			{
				$timezone=file_get_contents("backend/timezone.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system timezone (from system)\r\n");
			}
			else
			{
				$timezone="America/Toronto";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system timezone (default)\r\n");
			}
			if(file_exists("backend/name.txt"))
			{
				$name=file_get_contents("backend/name.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system name (from system)\r\n");
			}
			else
			{
				$name="";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system name (default)\r\n");
			}
			if(file_exists("backend/limit.txt"))
			{
				$overflow=file_get_contents("backend/limit.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system overflow level (from system)\r\n");
			}
			else
			{
				$overflow=0;
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system overflow level (default)\r\n");
			}
			if(file_exists("backend/stable.txt"))
			{
				$upgrade=file_get_contents("backend/stable.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system upgrading (from system)\r\n");
			}
			else
			{
				$upgrade="yes";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system upgrading (default)\r\n");
			}
			if(file_exists("backend/sysid.txt"))
			{
				$systemid=file_get_contents("backend/sysid.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system ID (from system)\r\n");
			}
			else
			{
				$systemid="Unset";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-system ID (default)\r\n");
			}
			if(file_exists("backend/light.txt"))
			{
				$light=file_get_contents("backend/light.txt");
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-light mode (from system)\r\n");
			}
			else
			{
				$systemid="no";
				$date=date("g:i:s");
				fwrite($fh,$ip . " at " . $date . ": Got setting-light mode (default)\r\n");
			}
			fclose($fh);
		}
		else
		{
			if(securitycheck() === false)
			{
				die("You are not an administrator. <a href=\"login.php\">Sign in</a> or <a href=\"index.php\">Cancel</a>.");
			}
			if(file_exists("backend/anon.txt"))
			{
				$anon=file_get_contents("backend/anon.txt");
			}
			else
			{
				$anon="no";
			}
			if(file_exists("backend/logging.txt"))
			{
				$logging=file_get_contents("backend/logging.txt");
			}
			else
			{
				$logging="no";
			}
			if(file_exists("backend/open.txt"))
			{
				$open=file_get_contents("backend/open.txt");
			}
			else
			{
				$open="yes";
			}
			if(file_exists("backend/posting.txt"))
			{
				$posting=file_get_contents("backend/posting.txt");
			}
			else
			{
				$posting="no";
			}
			if(file_exists("backend/type.txt"))
			{
				$type=file_get_contents("backend/type.txt");
			}
			else
			{
				$type=0;
			}
			if(file_exists("backend/unlock.txt"))
			{
				$unlock=file_get_contents("backend/unlock.txt");
			}
			else
			{
				$unlock=2;
			}
			if(file_exists("backend/iplock.txt"))
			{
				$iplock=file_get_contents("backend/iplock.txt");
			}
			else
			{
				$iplock=5;
			}
			if(file_exists("backend/dayrestrict.txt"))
			{
				$daylock=file_get_contents("backend/dayrestrict.txt");
			}
			else
			{
				$daylock=10;
			}
			if(file_exists("backend/status.txt"))
			{
				$status=file_get_contents("backend/status.txt");
			}
			else
			{
				$status="no";
			}
			if(file_exists("backend/eroc.txt"))
			{
				$eroc=file_get_contents("backend/eroc.txt");
			}
			else
			{
				$eroc="no";
			}
			if(file_exists("backend/pdreq.txt"))
			{
				$pdreq=file_get_contents("backend/pdreq.txt");
			}
			else
			{
				$pdreq="no";
			}
			if(file_exists("backend/searching.txt"))
			{
				$search=file_get_contents("backend/searching.txt");
			}
			else
			{
				$search="yes";
			}
			if(file_exists("backend/stripwords.txt"))
			{
				$stripwords=file_get_contents("backend/stripwords.txt");
			}
			else
			{
				$stripwords="";
			}
			if(file_exists("backend/sendmail.txt"))
			{
				$sendmail=file_get_contents("backend/sendmail.txt");
			}
			else
			{
				$sendmail="no";
			}
			if(file_exists("backend/email.txt"))
			{
				$email=base64_decode(file_get_contents("backend/email.txt"));
			}
			else
			{
				$email="lowendradiorequests@gmail.com";
			}
			if(file_exists("backend/timezone.txt"))
			{
				$timezone=file_get_contents("backend/timezone.txt");
			}
			else
			{
				$timezone="America/Toronto";
			}
			if(file_exists("backend/name.txt"))
			{
				$name=file_get_contents("backend/name.txt");
			}
			else
			{
				$name="";
			}
			if(file_exists("backend/limit.txt"))
			{
				$overflow=file_get_contents("backend/limit.txt");
			}
			else
			{
				$overflow=0;
			}
			if(file_exists("backend/stable.txt"))
			{
				$upgrade=file_get_contents("backend/stable.txt");
			}
			else
			{
				$upgrade="yes";
			}
			if(file_exists("backend/sysid.txt"))
			{
				$systemid=file_get_contents("backend/sysid.txt");
			}
			else
			{
				$systemid="Unset";
			}
			if(file_exists("backend/light.txt"))
			{
				$light=file_get_contents("backend/light.txt");
			}
			else
			{
				$systemid="no";
			}
		}
	}
?>
  <body>
  <h1 style="text-align:center; text-decoration:underline;"><?php echo $sysname; ?>MRS-Administration</h1>
  <form method="post" action="admin.php">
  <input type="hidden" name="s" value="y">
  <input type="hidden" name="clogging" value="<?php echo $logging; ?>">
  <input type="hidden" name="cposting" value="<?php echo $posting; ?>">
  <input type="hidden" name="canon" value="<?php echo $anon; ?>">
  <input type="hidden" name="copen" value="<?php echo $open; ?>">
  <input type="hidden" name="ctype" value="<?php echo $type; ?>">
  <input type="hidden" name="cunlock" value="<?php echo $unlock; ?>">
  <input type="hidden" name="ciplock" value="<?php echo $iplock; ?>">
  <input type="hidden" name="cdayrestrict" value="<?php echo $daylock; ?>">
  <input type="hidden" name="cstatus" value="<?php echo $status; ?>">
  <input type="hidden" name="ceroc" value="<?php echo $eroc; ?>">
  <input type="hidden" name="cpdreq" value="<?php echo $pdreq; ?>">
  <input type="hidden" name="csearch" value="<?php echo $search; ?>">
  <input type="hidden" name="cstripwords" value="<?php echo $stripwords; ?>">
  <input type="hidden" name="cdomail" value="<?php echo $sendmail; ?>">
  <input type="hidden" name="cemail" value="<?php echo $email; ?>">
  <input type="hidden" name="czone" value="<?php echo $timezone; ?>">
  <input type="hidden" name="cname" value="<?php echo $name; ?>">
  <input type="hidden" name="coverflow" value="<?php echo $overflow; ?>">
  <input type="hidden" name="cupgrade" value="<?php echo $upgrade; ?>">
  <input type="hidden" name="clight" value="<?php echo $light; ?>">
  <h3>System Settings</h3>
  System UID: <?php echo $systemid; ?> | <a href="sysidset.php">Get a new system ID number</a><br>
  System name: <input type="text" name="name" value="<?php echo $name; ?>"><br>
  Timezone: <input type="radio" name="zone" value="America/Toronto" <?php if ($timezone == "America/Toronto") { echo ("checked=\"checked\""); } ?>>Eastern | <input type="radio" name="zone" value="America/Winnipeg" <?php if ($timezone == "America/Winnipeg") { echo ("checked=\"checked\""); } ?>>Central | <input type="radio" name="zone" value="America/Denver" <?php if ($timezone == "America/Denver") { echo ("checked=\"checked\""); } ?>>Mountain | <input type="radio" name="zone" value="America/Phoenix" <?php if ($timezone == "America/Phoenix") { echo ("checked=\"checked\""); } ?>>Mountain (no DST) | <input type="radio" name="zone" value="America/Vancouver" <?php if ($timezone == "America/Vancouver") { echo ("checked=\"checked\""); } ?>>Pacific<br><br>
  Send emails: <input type="radio" name="domail" value="yes"  <?php if ($sendmail == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="domail" value="no"  <?php if ($sendmail == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  Administrator email address (reports and request notifications will go to this address): <input type="text" name="email" value="<?php echo $email; ?>"><br><br>
  Logging: <input type="radio" name="logging" value="yes" <?php if ($logging == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="logging" value="no"  <?php if ($logging == "no") { echo ("checked=\"checked\""); } ?>>No<br><br>
  Allow request status viewing by all members: <input type="radio" name="status" value="yes"  <?php if ($status == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="status" value="no"  <?php if ($status == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  Enable request view when system locked: <input type="radio" name="eroc" value="yes"  <?php if ($eroc == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="eroc" value="no"  <?php if ($eroc == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  <h3>System Actions</h3>
  <a href="ruledit.php">Edit rule list</a><br>
  <a href="archive.php">Archive all posts</a> | <a href="delall.php">Delete all posts</a><br>
  <a href="password.php">Change system password</a> | <a href="security.php">Change system security options</a><br>
  <a href="viewlog.php">View logfile</a><br>
  <h3>Posting</h3>
  Enable requests: <input type="radio" name="posting" value="yes" <?php if ($posting == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="posting" value="no"  <?php if ($posting == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  Anonymous requesting: <input type="radio" name="anon" value="yes" <?php if ($anon == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="anon" value="no"  <?php if ($anon == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  Allow open requests: <input type="radio" name="open" value="yes"  <?php if ($open == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="open" value="no"  <?php if ($open == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  <h3>Post Restrictions</h3>
  Disable requests for users who have unplayed/undeclined requests: <input type="radio" name="pdreq" value="yes"  <?php if ($pdreq == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="pdreq" value="no"  <?php if ($pdreq == "no") { echo ("checked=\"checked\""); } ?>>No<br><br>
  Restriction type: <input type="radio" name="type" value="0" <?php if ($type == "0") { echo ("checked=\"checked\""); } ?>>1 hour | <input type="radio" name="type" value="1" <?php if ($type == "1") { echo ("checked=\"checked\""); } ?>>3 hours | <input type="radio" name="type" value="2" <?php if ($type == "2") { echo ("checked=\"checked\""); } ?>>1 day<br>
  Username restriction:&nbsp;
  <select name="unlock">
  <option value="">-Select one-</option>
  <option value="1" <?php if ($unlock == "1") { echo ("selected=\"selected\""); } ?>>1</option>
  <option value="2" <?php if ($unlock == "2") { echo ("selected=\"selected\""); } ?>>2</option>
  <option value="3" <?php if ($unlock == "3") { echo ("selected=\"selected\""); } ?>>3</option>
  <option value="5" <?php if ($unlock == "5") { echo ("selected=\"selected\""); } ?>>5</option>
  <option value="10" <?php if ($unlock == "10") { echo ("selected=\"selected\""); } ?>>10</option>
  <option value="0" <?php if ($unlock == "0") { echo ("selected=\"selected\""); } ?>>None</option>
  </select><br>
  IP restriction:&nbsp;
  <select name="iplock">
  <option value="">-Select one-</option>
  <option value="1" <?php if ($iplock == "1") { echo ("selected=\"selected\""); } ?>>1</option>
  <option value="2" <?php if ($iplock == "2") { echo ("selected=\"selected\""); } ?>>2</option>
  <option value="3" <?php if ($iplock == "3") { echo ("selected=\"selected\""); } ?>>3</option>
  <option value="5" <?php if ($iplock == "5") { echo ("selected=\"selected\""); } ?>>5</option>
  <option value="10" <?php if ($iplock == "10") { echo ("selected=\"selected\""); } ?>>10</option>
  <option value="0" <?php if ($iplock == "0") { echo ("selected=\"selected\""); } ?>>None</option>
  </select><br>
  Daily restriction:&nbsp;
  <select name="dayrestrict">
  <option value="">-Select one-</option>
  <option value="1" <?php if ($daylock == "1") { echo ("selected=\"selected\""); } ?>>1</option>
  <option value="2" <?php if ($daylock == "2") { echo ("selected=\"selected\""); } ?>>2</option>
  <option value="3" <?php if ($daylock == "3") { echo ("selected=\"selected\""); } ?>>3</option>
  <option value="5" <?php if ($daylock == "5") { echo ("selected=\"selected\""); } ?>>5</option>
  <option value="10" <?php if ($daylock == "10") { echo ("selected=\"selected\""); } ?>>10</option>
  <option value="0" <?php if ($daylock == "0") { echo ("selected=\"selected\""); } ?>>None</option>
  </select><br>
  Overflow restriction:&nbsp;
  <select name="overflow">
  <option value="">-Select one-</option>
  <option value="3" <?php if ($overflow == "3") { echo ("selected=\"selected\""); } ?>>3</option>
  <option value="5" <?php if ($overflow == "5") { echo ("selected=\"selected\""); } ?>>5</option>
  <option value="6" <?php if ($overflow == "6") { echo ("selected=\"selected\""); } ?>>6</option>
  <option value="9" <?php if ($overflow == "9") { echo ("selected=\"selected\""); } ?>>9</option>
  <option value="10" <?php if ($overflow == "10") { echo ("selected=\"selected\""); } ?>>10</option>
  <option value="13" <?php if ($overflow == "13") { echo ("selected=\"selected\""); } ?>>13</option>
  <option value="15" <?php if ($overflow == "15") { echo ("selected=\"selected\""); } ?>>15</option>
  <option value="16" <?php if ($overflow == "16") { echo ("selected=\"selected\""); } ?>>16</option>
  <option value="19" <?php if ($overflow == "19") { echo ("selected=\"selected\""); } ?>>19</option>
  <option value="20" <?php if ($overflow == "20") { echo ("selected=\"selected\""); } ?>>20</option>
  <option value="0" <?php if ($overflow == "0") { echo ("selected=\"selected\""); } ?>>None</option>
  </select><br>
  <h3>Song Lists</h3>
  Allow searching: <input type="radio" name="search" value="yes"  <?php if ($search == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="search" value="no"  <?php if ($search == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  Strip the following words from searches (comma-separated): <input type="text" name="stripwords" value="<?php echo $stripwords; ?>"><br>
  Enable light mode: <input type="radio" name="light" value="yes"  <?php if ($light == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="light" value="no"  <?php if ($light == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  <a href="listedit.php">Edit song database</a><br>
  <h3>System Upgrades</h3>
  Check only for stable builds: <input type="radio" name="upgrade" value="yes"  <?php if ($upgrade == "yes") { echo ("checked=\"checked\""); } ?>>Yes | <input type="radio" name="upgrade" value="no"  <?php if ($upgrade == "no") { echo ("checked=\"checked\""); } ?>>No<br>
  <a href="upgrade/index.php">Check for updates</a><br>
  <input type="submit"><input type="button" value="Cancel" onclick="window.location.href='index.php'">
  </form>
  </body>
</html>