<?php
	//Get system name
	if(file_exists("backend/name.txt") && file_get_contents("backend/name.txt") != "")
	{
		$sysname=file_get_contents("backend/name.txt") . " ";
	}
	else
	{
		$sysname="";
	}
?>
<?php
	//Administrative check function (on a separate page)
	if(file_exists("backend/securitycheck.php"))
	{
		include ("backend/securitycheck.php");
	}
	else
	{
		die("Failed to open file \"backend/securitycheck.php\" in read mode. It should now be microwaved.");
	}
?>
<?php
	if(file_exists("backend/logging.txt") && file_get_contents("backend/logging.txt") == "yes")
	{
		//Change the timezone
		if(file_exists("backend/timezone.txt"))
		{
			date_default_timezone_set(file_get_contents("backend/timezone.txt"));
		}
		else
		{
			date_default_timezone_set("America/Toronto");
		}
		//Logging enabled on system
		$ip=$_SERVER['REMOTE_ADDR'];
		$date=date("g:i:s");
		$fh=fopen("log/" . date("Ymd") . ".txt",'a') or die("Failed to open file \"log/" . date("Ymd") . ".txt\" in append mode. It should now be microwaved.");
		fwrite($fh,$ip . " at " . $date . ": Visited about page\r\n");
		if(file_exists("backend/version.txt"))
		{
			$verinfo=explode("\r\n",file_get_contents("backend/version.txt"));
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Obtained version information\r\n");
			$verinfo[0]=explode("|",$verinfo[0]);
		}
		else
		{
			$date=date("g:i:s");
			fwrite($fh,$ip . " at " . $date . ": Failed to obtain version information\r\n");
			trigger_error("No version information found.",E_USER_WARNING);
			$verinfo=array(array("0","0","0",false),"","January 1, 1970 at 12:00 AM Eastern Time");
		}
		fclose($fh);
	}
	else
	{
		//Logging disabled
		if(file_exists("backend/version.txt"))
		{
			$verinfo=explode("\r\n",file_get_contents("backend/version.txt"));
			$verinfo[0]=explode("|",$verinfo[0]);
		}
		else
		{
			trigger_error("No version information found.",E_USER_WARNING);
			$verinfo=array(array("0","0","0",false),"","January 1, 1970 at 12:00 AM Eastern Time");
		}
	}
?>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01//EN" "http://www.w3.org/TR/html4/strict.dtd">
<html>
  <head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="generator" content="CoffeeCup HTML Editor (www.coffeecup.com)">
    <meta name="created" content="Wed, 17 Jun 2015 12:33:52 GMT">
    <meta name="description" content="Listening to a live stream? Got a song you have to hear? This is the place to request it!">
	<link rel="shortcut icon" href="backend/favicon.ico">
    <title><?php echo $sysname; ?>Music Request System-About</title>
    
    <style type="text/css">
    <!--
    body {
      color:#000000;
	  background-color:#FFFFFF;
      background-image:url('backend/background.gif');
      background-repeat:repeat;
    }
    a  { color:#FFFFFF; background-color:#0000FF; }
    a:visited { color:#FFFFFF; background-color:#800080; }
    a:hover { color:#000000; background-color:#00FF00; }
    a:active { color:#000000; background-color:#FF0000; }
    -->
    </style>
  </head>
  <body>
  <h1 style="text-align:center; text-decoration:underline;">About the <?php echo $sysname; ?>Music Request System</h1>
  <?php
	echo ("<p>Version: " . $verinfo[0][0] . "." . $verinfo[0][1]);
	if(trim($verinfo[1]) != "")
	{
		echo $verinfo[1];
	}
	echo ("<br>\r\nRevision: " . $verinfo[0][2] . "<br>\r\nReleased: " . $verinfo[2] . "</p>\r\n");
  ?>
  <p>The Music Request System is copyright &copy; 2015-2017 Brad Hunter/<a href="http://www.youtube.com/user/carnelprod666">CarnelProd666</a>. Unauthorized dupication or motifications are prohibited. As a system administrator, if you obtained these files from anywhere else but <a href="http://firealarms.redbat.ca/mrs/">here</a>, they are <u>unauthorized</u> and cannot be trusted. No warranty, express or implied, is offered with this software except in basic support circumstances. This system may track your movements, however it will let you know of this in advance (unless it has been illegally modified to not do so). Comments should be directed to <a href="contact.php">the system administrator</a> and/or <a href="http://firealarms.redbat.ca/contact.php">the software writer</a>.</p>
  <p>The MRS makes use of <a href="http://jquery.com/">JQuery</a> and the <a href="http://tablesorter.com/docs/">TableSorter</a> plugin, each of which is copyright their respective owners.</p>
  <a href="index.php">Go back</a>
  </form>
  </body>
</html>